<?php
class Executor {
    public static function doit($sql, $params = []) {
        $con = Database::getInstance()->getConnection();

        $stmt = $con->prepare($sql);
        if (!$stmt) {
            die('Error en prepare: ' . $con->error);
        }

        if (!empty($params)) {
            // Vincula los parámetros dinámicamente
            $types = '';
            foreach ($params as $param) {
                if (is_int($param)) {
                    $types .= 'i';
                } elseif (is_float($param)) {
                    $types .= 'd';
                } else {
                    $types .= 's';
                }
            }
            
            $bindParams = array($types);
            foreach ($params as $key => $value) {
                $bindParams[] = &$params[$key];
            }
            
            call_user_func_array(array($stmt, 'bind_param'), $bindParams);
        }

        if (!$stmt->execute()) {
            die('Error en execute: ' . $stmt->error);
        }

        $result = $stmt->get_result();
        return array($result, $con->insert_id);
    }
}
?>
