<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <!-- ***************************************************** -->
                    <div class="modal fade" id="showModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-body text-center p-5">
                                    <div class="mb-4">
                                        <lord-icon
                                            src="https://cdn.lordicon.com/jtiihjyw.json"
                                            trigger="loop"
                                            state="loop-spin"
                                            colors="primary:#1b1091,secondary:#ffc738,tertiary:#ffffff"
                                            style="width:100px;height:100px">
                                        </lord-icon>
                                    </div>
                                    <h4 class="mb-3">Venta # <?php echo isset($_SESSION['numero_compra']) ? $_SESSION['numero_compra'] : ''; ?></h4>
                                    <div class="form-group">
                                        <label for="printOption" class="form-label">Elija el tipo del comprobante:</label>
                                        <select id="printOption" class="form-select">
                                            <option value="">Seleccionar documento</option>
                                            <option value="index.php?action=ticketventa&tid=<?php echo $_SESSION['numero_compra']; ?>">Ticket</option>
                                            <!-- <option value="factura.php">Factura</option> -->
                                        </select>
                                    </div>
                                    <div class="d-flex justify-content-center mt-4">
                                        <button type="button" class="btn btn-outline-secondary me-3" data-bs-dismiss="modal"><i class="ri-close-line me-1"></i>Cerrar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script>
                        document.getElementById('printOption').addEventListener('change', function() {
                            var selectedOption = this.value;
                            if (selectedOption) {
                                window.open(selectedOption, '_blank');
                            }
                        });
                    </script>
                    <?php   if (isset($_SESSION['numero_compra'])) {
                        unset($_SESSION['numero_compra']);
                        }
                        if (isset($_SESSION['show_modal']) && $_SESSION['show_modal']) {
                            echo '<script>$(document).ready(function() { $("#showModal").modal("show"); });</script>';
                            unset($_SESSION['show_modal']); 
                        }
                    ?>
                    <?php if (isset($_SESSION['success_message'])) : ?>
                        <script>
                            Swal.fire({
                                icon: "success",
                                title: "Éxito",
                                text: "<?php echo $_SESSION['success_message']; ?>",
                                timer: 1000,
                                showConfirmButton: true
                            });
                        </script>
                    <?php unset($_SESSION['success_message']); ?>
                    <?php endif; ?>
                    <!-- ************************************************************* -->
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0 text-white">Registro de Ventas</h5>
                        </div>
                        <div class="card-body">
                            <form enctype="multipart/form-data" class="tablelist-form" autocomplete="off" method="post" action="index.php?action=registro">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="codigo-barras" class="form-label text-primary">Código de Barras</label>
                                        <div class="input-group">
                                            <input type="text" id="codigo-barras" class="form-control" placeholder="Escanea o ingresa manualmente" autofocus>
                                            <button class="btn btn-outline-secondary" type="button" id="start-scan">
                                                <i class="ri-camera-line"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" type="button" id="stop-scan" style="display: none;">
                                                <i class="ri-stop-circle-line"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="select-articulo" class="form-label text-primary">Articulo</label>
                                        <select name="articulo" id="select-articulo" class="form-select miSelect1 rounded-pill mb-3" aria-label="Default select example">
                                            <option value="">Seleccionar</option>
                                            <?php
                                            $articulos = ArticuloData::vercontenido();
                                            foreach ($articulos as $arti) { ?>
                                                <option value="<?= $arti->id; ?>"><?= $arti->nombre; ?>
                                            </option>
                                        <?php } ?>
                                        </select>
                                    </div>
                                    <div style="background-color: #f2f2f2;" class="col-md-4">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label for="unidad" class="form-label text-primary">Unidad</label>
                                                <select name="unidad" id="unidad" class="form-control"><option value="">Seleccionar</option></select>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="cantidad_unidad" class="form-label text-primary">Cantidad</label>
                                                <input type="number" readonly="readonly" name="cantidad_unidad" class="form-control" id="cantidad_unidad">
                                            </div>
                                            <div class="col-md-3">
                                                <label for="precio_unidad" class="form-label text-primary">P. venta</label>
                                                <input type="number" readonly="readonly" name="precio_unidad" class="form-control" id="precio_unidad">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="basiInput" class="form-label text-primary">Almacén</label>
                                        <select name="almacen" id="almacen" class="form-control miSelect1">
                                            <option value="">Selecionar</option>
                                        </select>
                                    </div>
                                    <input type="hidden" id="data-cantidadd" name="cantidadd" class="form-control">
                                    <div class="col-md-2">
                                        <label for="cantidad" class="form-label text-primary">Cantidad</label>
                                        <input type="text" name="cantidad" id="cantidad" class="form-control">
                                    </div>
                                    <!-- valor de la moneda -->
                                    <div class="col-md-2">
                                        <label for="Meneda" class="form-label text-primary">Moneda</label>
                                        <select name="tipo_moneda" id="moneda" class="form-select moneda">
                                        <?php
                                        $articulos = MonedasData::getAll();
                                        foreach ($articulos as $arti) {
                                            $selected = ($arti->codigo == 'SOL') ? 'selected' : '';
                                        ?>
                                            <option 
                                                value="<?= $arti->codigo; ?>" 
                                                data-simbolo="<?= $arti->simbolo; ?>"
                                                data-tasa="<?= $arti->tasa_cambio; ?>"
                                                <?= $selected; ?>
                                            >
                                                <?= $arti->simbolo; ?> - <?= $arti->codigo; ?>
                                            </option>
                                        <?php } ?>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="precioventa" class="form-label text-primary">Precio venta</label>
                                        <div class="input-group">
                                            <span class="input-group-text simbolo-moneda">MXN</span>
                                            <input type="text" name="precioventa" id="precioventa" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-1 d-flex align-items-end">
                                        <button id="btnAgregar" title="Agregar a la lista" class="btn btn-info btnguardar w-100"><i class="ri-add-line align-bottom me-1"> </i> </button>
                                    </div>
                                </div>
                                <hr>
                                <table class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%; font-size: 10px;">
                                    <thead class="bg-primary text-light">
                                        <tr>
                                            <th>Articulo</th>
                                            <th>Unidad</th>
                                            <th width="80px">Cantidad</th>
                                            <th width="80px">P. Venta</th>
                                            <th width="120px">SubTotal</th>
                                            <th width="80px">P. V. config.</th>
                                            <th>Almacén</th>
                                            <th width="5px"><i class="ri-delete-bin-2-line"></i></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                                <hr>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-0">
                                            <label for="subtotal" class="form-label fs-6">Subtotal</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-primary text-white">$</span>
                                                <input type="text" class="form-control rounded-pill border-primary" name="subtotal" id="subtotal" readonly>
                                                <span class="input-group-text bg-primary text-white simbolo-moneda">MXN</span>
                                            </div>
                                        </div>
                                        <div class="mb-2">
                                            <label for="descuento" class="form-label fs-6">Descuento</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-warning text-white">$</span>
                                                <input type="text" class="form-control rounded-pill border-warning" name="descuento" id="descuento" placeholder="Aplica descuento...">
                                                <span class="input-group-text bg-warning text-white simbolo-moneda">MXN</span>
                                            </div>
                                        </div>
                                        <div class="mb-2 form-check">
                                            <?php
                                            $iva_config = ConfiguracionValoresData::getByClave("igv");
                                            $tasa_iva = $iva_config ? $iva_config->valor : 0; // fallback a 16 si no se encuentra
                                            ?>
                                            <input type="checkbox" class="form-check-input" id="igv">
                                            <label class="form-check-label text-secondary fs-6" for="igv">Aplicar IGV del <?= $tasa_iva; ?>%</label>
                                        </div>
                                        <div class="mb-2">
                                            <label for="total-igv" class="form-label fs-6">Total IVA</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-success text-white">$</span>
                                                <input type="text" class="form-control rounded-pill border-success" name="igv" id="total-igv" readonly>
                                                <span class="input-group-text bg-success text-white simbolo-moneda">MXN</span>
                                            </div>
                                        </div>
                                        <div class="mb-2">
                                            <label for="total" class="form-label fs-6">Total</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-danger text-white">$</span>
                                                <input type="text" class="form-control rounded-pill border-danger" name="total" id="total" readonly>
                                                <span class="input-group-text bg-danger text-white simbolo-moneda">MXN</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 row mb-0">
                                        <div class="col-md-4">
                                            <label for="tipoventa" class="form-label text-primary">Método venta</label>
                                            <select name="tipoventa" id="tipoventa" class="form-select tipoventa" aria-label="Default select example">
                                                <option value="contado">Al cotado</option>
                                                <option value="credito">Al credito</option>
                                            </select>
                                        </div>
                                        <div class="col-md-4" id="adelantoContainer" style="display: none;">
                                            <label for="adelanto" class="form-label text-primary">Adelanto</label>
                                            <input type="text" name="adelanto" id="adelanto" class="form-control">
                                        </div>
                                        <div class="col-md-4" id="comprobantes" style="display: none;">
                                            <label for="comprobante" class="form-label text-primary">Nº Comprobante</label>
                                            <input type="text" name="comprobante" id="comprobante" class="form-control">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="accion" class="form-label text-primary">Tipo venta</label>
                                            <select name="accion" id="accion" class="form-select" aria-label="Default select example">
                                                <option value="1">Venta Estandarizada</option>
                                                <option value="2">Cotización</option>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="factura" class="form-label text-primary">Factura/Folio</label>
                                            <textarea rows="1" class="form-control" name="factura"></textarea>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="cliente" class="form-label text-primary">Cliente</label>
                                            <select name="cliente" id="cliente" class="form-select miSelect1 proveedores" aria-label="Default select example">
                                                <option value="">Seleccionar</option>
                                                <?php
                                                $clientes = ClienteData::vercontenido_tipo("Cliente");
                                                foreach ($clientes as $clints) { ?>
                                                    <option value="<?= $clints->id; ?>"><?= $clints->nombre; ?>
                                                </option>
                                            <?php } ?>
                                            </select>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="descripcion" class="form-label text-primary">Descripción de la venta</label>
                                            <textarea class="form-control" name="descripcion"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div style="display: flex; justify-content: flex-end;">
                                    <input type="hidden" name="actions" value="23">
                                    <div class="col-md-2 d-flex align-items-end">
                                        <button type="submit" class="btn btn-info btnguardar w-100" id="add-btn">Registrar Venta</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- cabio de moneda -->
<script>
    $(document).ready(function () {
    // Variable para almacenar la moneda actual
    var monedaActual = $('#moneda').val();

    function actualizarUI() {
        var selectedOption = $('#moneda option:selected');
        var simbolo = selectedOption.data('simbolo');
        var tasa = selectedOption.data('tasa');
        var codigo = selectedOption.val();

        // Cambiar los spans con clase .simbolo-moneda
        $('.simbolo-moneda').text(simbolo);
        $('.monedas_segundo').val(codigo);

        if (codigo !== 'VES') {
            $('#adelantoContainer1').show();
            $('#cambio').val(tasa);
        } else {
            $('#adelantoContainer1').hide();
            $('#cambio').val('');
        }
    }

    // Ejecutar al inicio
    actualizarUI();

    // Detectar cambio de moneda
    $('#moneda').change(function () {
        var nuevaMoneda = $(this).val();
        
        // Verificar si hay filas en la tabla (excepto encabezados)
        if ($('table tbody tr').length > 0) {
            // Mostrar confirmación
            Swal.fire({
                title: '¿Cambiar moneda?',
                text: 'Si cambia la moneda, todos los datos agregados a la tabla se eliminarán para mantener consistencia en los registros.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, cambiar moneda',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Usuario confirmó cambiar la moneda
                    monedaActual = nuevaMoneda;
                    actualizarUI();
                    
                    // Limpiar la tabla
                    $('table tbody').empty();
                    
                    // Recalcular totales
                    calcularTotales();
                    actualizarEstadoBoton();
                    
                    Swal.fire(
                        'Moneda cambiada',
                        'La moneda se ha cambiado y la tabla se ha limpiado.',
                        'success'
                    );
                } else {
                    cambiandoMoneda = true; 
                    $('#moneda').val(monedaActual);
                    cambiandoMoneda = false; 
                }
            });
        } else {
            // No hay datos en la tabla, simplemente actualizar la moneda
            monedaActual = nuevaMoneda;
            actualizarUI();
        }
    });
});
 </script>
<script>
    $(document).ready(function() {
        if ($('#tipoventa').val() === 'contado') {
            $('#adelantoContainer').hide();
            $('#comprobantes').hide();
        }
        $('#tipoventa').change(function() {
            if ($(this).val() === 'credito') {
                $('#adelantoContainer').show();
                $('#comprobantes').show();
            } else {
                $('#adelantoContainer').hide();
                $('#comprobantes').hide();
            }
        });
    });
</script>
<script>
$(document).ready(function(){
    $('#select-articulo').change(function(){
        var productoID = $(this).val(); 
        if(productoID){
            $.ajax({
                type:'POST',
                url:'index.php?action=apiprecios', 
                data:'id_producto='+productoID,
                success:function(data){
                    $('select[name="unidad"]').html('<option value="">Seleccionar</option>' + data);
                    $('input[name="cantidad_unidad"]').val('');
                    $('input[name="precio_unidad"]').val(''); 
                }
            }); 
        } else {
            // Si no se selecciona ningún producto, limpiar y mostrar la opción nula
            $('select[name="unidad"]').html('<option value="">Seleccionar</option>');  
            $('input[name="cantidad_unidad"]').val('');
            $('input[name="precio_unidad"]').val('');
        }
    });
    
    $('select[name="unidad"]').change(function(){
        var cantidad_unidad = $(this).find('option:selected').data('cantidad');  
        var precio_unidad = $(this).find('option:selected').data('precio');
        
        if (cantidad_unidad !== undefined && precio_unidad !== undefined) {
            $('input[name="cantidad_unidad"]').val(cantidad_unidad);
            $('input[name="precio_unidad"]').val(precio_unidad);
        } else {
            $('input[name="cantidad_unidad"]').val('');
            $('input[name="precio_unidad"]').val('');
        }
    });
    $('#select-articulo').change(function(){
        var Idproductos = $(this).val(); 
        if (Idproductos) {
            $.ajax({
                url: 'index.php?action=apicantidadporalmacen1',
                type: 'GET',
                data: { producto_id: Idproductos },
                success: function(data) {
                    console.log("Datos recibidos: ", data);
                    console.log("Entrando en la función success");

                    $('#almacen').empty().append('<option value="">Seleccionar</option>');
                    if (Array.isArray(data) && data.length > 0) {
                        $.each(data, function(key, value) {
                            if (value && value.id_almacen && value.nombre_almacen && value.total_almacen) {
                                $('#almacen').append('<option value="' + value.id_almacen + '" data-cantidadd="' + value.total_almacen + '">' + value.nombre_almacen + ' (' + value.total_almacen + ')</option>');
                            }
                        });
                        console.log("Opciones añadidas: ", $('#almacen').html());
                    } else {
                        console.log("Los datos no son un array o están vacíos");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la solicitud: ", error);
                }
            });
        } else {
            $('#almacen').empty().append('<option value="">Seleccionar</option>');
        }
    });
    $('#almacen').on('change', function() {
        var cantidadDisponible = $(this).find('option:selected').data('cantidadd');
        $('#data-cantidadd').val(cantidadDisponible);
    });

    $('#cantidad').on('input', function() {
        actualizarPrecioVenta();
        var cantidadMaxima = $('#data-cantidadd').val();
        var cantidadIngresada = $(this).val();

        if (parseInt(cantidadIngresada) > parseInt(cantidadMaxima)) {
            $(this).val(cantidadMaxima);
        }
    });

    /*
    $('#unidad').change(function() {
        actualizarPrecioVenta();
    });
    
    function actualizarPrecioVenta() {
        var cantidad = $('#cantidad').val();
        var precioUnitario = $('#precio_unidad').val();
        if ($.isNumeric(cantidad) && $.isNumeric(precioUnitario)) {
            var precioVenta = parseFloat(precioUnitario);
            $('#precioventa').val(precioVenta.toFixed(2));
        } else {
            $('#precioventa').val('');
        }
    }*/
    $('#cantidad, #moneda, #unidad').on('input change', function() {
        actualizarPrecioVenta();
    });
    function actualizarPrecioVenta() {
        var cantidad = $('#cantidad').val();
        var precioUnitarioBase = $('#precio_unidad').val(); // Precio en SOLES (asumido)
        var monedaSeleccionada = $('#moneda option:selected');
        var tasaCambio = parseFloat(monedaSeleccionada.data('tasa')); // Tasa de la moneda seleccionada

        if ($.isNumeric(cantidad) && $.isNumeric(precioUnitarioBase)) {
            // Convertir el precio unitario a la moneda seleccionada
            var precioUnitarioConvertido = parseFloat(precioUnitarioBase) * tasaCambio;
            
            var simboloMoneda = monedaSeleccionada.data('simbolo');
            $('#precioventa').val( precioUnitarioConvertido.toFixed(2));
        } else {
            $('#precioventa').val('');
        }
    }
    actualizarPrecioVenta();

});
</script>
<style>
    .campo-faltante {
        border-color: red !important;
    }
</style>
<script>
    function actualizarEstadoBoton() {
        const tbody = document.querySelector('table tbody');
        const addBtn = document.getElementById('add-btn');
        const hasProducts = tbody.querySelectorAll('tr').length > 0;
        
        if (addBtn) {
            if (hasProducts) {
                // Activar el botón
                addBtn.removeAttribute('disabled');
                addBtn.classList.remove('disabled');
                addBtn.style.opacity = '1';
                addBtn.style.cursor = 'pointer';
                addBtn.style.pointerEvents = 'auto';
            } else {
                // Desactivar el botón
                addBtn.setAttribute('disabled', 'disabled');
                addBtn.classList.add('disabled');
                addBtn.style.opacity = '0.5';
                addBtn.style.cursor = 'not-allowed';
                addBtn.style.pointerEvents = 'none';
            }
        }
    }

    let lastScannedCode = '';
    let lastScanTime = 0;
    const scanCooldown = 500; // 500ms de espera entre escaneos

function limpiarCampos() {
    // Limpiar código de barras
    document.getElementById('codigo-barras').value = '';
    
    // Limpiar unidad y sus campos relacionados
    document.getElementById('unidad').innerHTML = '<option value="">Seleccionar</option>';
    document.getElementById('cantidad_unidad').value = '';
    document.getElementById('precio_unidad').value = '';
    
    // Limpiar almacén
    document.getElementById('almacen').innerHTML = '<option value="">Seleccionar</option>';
    document.getElementById('data-cantidadd').value = '';
    
    // Limpiar cantidad y precio
    document.getElementById('cantidad').value = '';
    document.getElementById('precioventa').value = '';
    
    // Enfocar el campo de código de barras
    document.getElementById('codigo-barras').focus();
}

function buscarProductoPorCodigo(codigo) {
    fetch(`index.php?action=buscadorproducto&codigo=${codigo}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const articulo = data.articulo;
                const tbody = document.querySelector('table tbody');
                const filas = tbody.querySelectorAll('tr');
                let productoExistente = false;

                for (let fila of filas) {
                    const articuloId = fila.querySelector('input[name="articulo_[]"]').value;
                    const unidadId = fila.querySelector('input[name="unidad_[]"]').value;

                    // Obtener el almacén ya sea de un select o de un input oculto
                    let almacenId;
                    const selectAlmacen = fila.querySelector('select[name="almacen_[]"]');
                    const inputAlmacen = fila.querySelector('input[name="almacen_[]"]');
                    
                    if (selectAlmacen) {
                        almacenId = selectAlmacen.value;
                    } else if (inputAlmacen) {
                        almacenId = inputAlmacen.value;
                    }
                    
                    if (articuloId == articulo.id && 
                        almacenId == articulo.almacen_id && 
                        unidadId == articulo.unidad_id) {
                        
                        const cantidadInput = fila.querySelector('input[name="cantidad_[]"]');
                        const nuevaCantidad = parseInt(cantidadInput.value) + 1;
                        cantidadInput.value = nuevaCantidad;
                        
                        const precio = parseFloat(fila.querySelector('input[name="precioProducto_[]"]').value);
                        const subtotal = nuevaCantidad * precio;
                        fila.querySelector('.subtotalProducto').textContent = subtotal.toFixed(2) + ' MXN';
                        
                        // Mostrar notificación sutil
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        });

                        Toast.fire({
                            icon: 'success',
                            title: `Cantidad actualizada: ${nuevaCantidad}`
                        });
                        
                        productoExistente = true;
                        break;
                    }
                }

                if (!productoExistente) {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td><input type="hidden" name="articulo_[]" value="${articulo.id}" />${articulo.nombre}</td>
                        <td><input type="hidden" name="unidad_[]" value="${articulo.unidad_id}">${articulo.unidad_nombre}</td>
                        <td><input type="number" name="cantidad_[]" value="1" style="width: 50px;" /></td>
                        <td><input type="number" name="precioProducto_[]" value="${articulo.precio_venta}" style="width: 60px;" /></td>
                        <td class="subtotalProducto">${articulo.precio_venta} MXN</td>
                        <td><input type="hidden" name="cantidad_unidad_[]" value="${articulo.cantidad_unidad}" />${articulo.precio_venta}</td>
                        <td>
                            <select name="almacen_[]" class="form-select form-select-sm" style="width: 150px;">
                                <option value="${articulo.almacen_id}" selected>${articulo.almacen_nombre}</option>
                            </select>
                        </td>
                        <td><button type="button" class="btn btn-danger btn-sm btnEliminar"><i class="ri-delete-bin-2-line"></i></button></td>
                    `;
                    tbody.appendChild(row);

                    // Cargar los almacenes disponibles para este producto
                    cargarAlmacenesDisponibles(articulo.id, row);
                }

                // Actualizar totales
                calcularTotales();

                // Activar el botón de registro inmediatamente
                const addBtn = document.getElementById('add-btn');
                if (addBtn) {
                    addBtn.removeAttribute('disabled');
                    addBtn.classList.remove('disabled');
                    addBtn.style.opacity = '1';
                    addBtn.style.cursor = 'pointer';
                    addBtn.style.pointerEvents = 'auto';
                }

                // Reproducir sonido de confirmación
                try {
                const audio = new Audio('assets/sounds/beep.mp3');
                    audio.play().catch(error => {
                        console.log('No se pudo reproducir el sonido:', error);
                    });
                } catch (error) {
                    console.log('Error al crear el audio:', error);
                }

                // Limpiar todos los campos
                limpiarCampos();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'Producto no encontrado'
                });
            }
        });
}

    function cargarAlmacenesDisponibles(productoId, row) {
        fetch(`index.php?action=apicantidadporalmacen1&producto_id=${productoId}`)
            .then(response => response.json())
            .then(data => {
                const select = row.querySelector('select[name="almacen_[]"]');
                const valorActual = select.value; // Guardar el valor actualmente seleccionado
                
                select.innerHTML = ''; // Limpiar opciones existentes
                
                data.forEach(almacen => {
                    const option = document.createElement('option');
                    option.value = almacen.id_almacen;
                    option.textContent = `${almacen.nombre_almacen} (${almacen.total_almacen})`;
                    if (almacen.id_almacen == valorActual) {
                        option.selected = true;
                    }
                    select.appendChild(option);
                });
            });
    }

    // Evento para actualizar el almacén seleccionado
    $(document).on('change', 'select[name="almacen_[]"]', function() {
        calcularTotales();
    });

    // Inicializar el estado del botón al cargar la página
    $(document).ready(function() {
        actualizarEstadoBoton();
    });

    // Agregar evento para el botón de eliminar
    $(document).on('click', '.btnEliminar', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        calcularTotales();
        actualizarEstadoBoton();
    });

    // Agregar evento para cambios en la tabla
    $(document).on('input', 'input[name="cantidad_[]"], input[name="precioProducto_[]"]', function() {
        let $row = $(this).closest('tr');
        let cantidad = parseFloat($row.find('input[name="cantidad_[]"]').val()) || 0;
        let precio = parseFloat($row.find('input[name="precioProducto_[]"]').val()) || 0;
        $row.find('.subtotalProducto').text((cantidad * precio).toFixed(2));
        calcularTotales();
        actualizarEstadoBoton();
    });

    // Agregar evento para el botón de agregar manualmente
    $('#btnAgregar').on('click', function(e) {
        e.preventDefault();

        var articulo = $('#select-articulo').val();
        var articulo1 = $('select[name="articulo"] option:selected').text();
        var unidad = $('select[name="unidad"] option:selected').text();
        var unidad1 = $('select[name="unidad"]').val();
        var cantidad = parseFloat($('input[name="cantidad"]').val());
        var precio = parseFloat($('input[name="precioventa"]').val());
        var almacen1 = $('select[name="almacen"] option:selected').text();
        var almacen = $('#almacen').val();

        var cantidad_unidad = parseFloat($('input[name="cantidad_unidad"]').val());
        var precio_unidad = parseFloat($('input[name="precio_unidad"]').val());
        var cantidadd = parseFloat($('input[name="cantidadd"]').val());
        var moneda = $('select[name="tipo_moneda"] option:selected').text();

        var subtotalProducto = cantidad * precio ;
        // Validaciones
        if (!articulo) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Por favor seleccione un artículo'
            });
            return;
        }

        if (!unidad1) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Por favor seleccione una unidad'
            });
            return;
        }

        if (!cantidad || cantidad <= 0) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Por favor ingrese una cantidad válida'
            });
            return;
        }

        if (!precio || precio <= 0) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Por favor ingrese un precio válido'
            });
            return;
        }

        if (!almacen) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Por favor seleccione un almacén'
            });
            return;
        }

        var newRow = `<tr>
            <td><input type="hidden" name="articulo_[]" value="${articulo}" />${articulo1}</td>
            <td><input type="hidden" name="unidad_[]" value="${unidad1}">${unidad}</td>
            <td><input type="number" name="cantidad_[]" value="${cantidad}" style="width: 50px;" /></td>
            <td><input type="number" name="precioProducto_[]" value="${precio.toFixed(2)}" style="width: 60px;" /></td>
            
            <td class="subtotalProducto">${subtotalProducto.toFixed(2)} <span class="simbolo-moneda">${moneda}</span></td>
            <td><input type="hidden" name="cantidad_unidad_[]" value="${cantidad_unidad}" />${precio_unidad}</td>
            <td><input type="hidden" name="almacen_[]" value="${almacen}" />${almacen1}</td>
            <td><button class="btn btn-danger btn-sm btnEliminar"><i class="ri-delete-bin-2-line"></i></button></td>
        </tr>`;

        $('table tbody').append(newRow);

        // Limpiar todos los campos después de agregar
        limpiarCampos();
        
        // Resetear el select de artículo
        $('#select-articulo').val('').trigger('change');

        calcularTotales();
        actualizarEstadoBoton();
    });

    // Agregar evento para el escaneo de código de barras
    $('#codigo-barras').on('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            const codigo = $(this).val().trim();
            if (codigo) {
                buscarProductoPorCodigo(codigo);
                $(this).val('');
}
        }
    });

</script>

<!-- Modal para la cámara -->
<div class="modal fade" id="cameraModal" tabindex="-1" aria-labelledby="cameraModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cameraModalLabel">Escaneo con Cámara</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="interactive" class="viewport"></div>
                <div id="result" class="alert alert-info" style="display: none;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Incluir QuaggaJS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/quagga/0.12.1/quagga.min.js"></script>

<script>
// Configuración para la pistola láser
document.getElementById('codigo-barras').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        const codigo = this.value.trim();
        if (codigo) {
            buscarProductoPorCodigo(codigo);
            this.value = ''; // Limpiar el campo después de escanear
        }
    }
});

// Configuración para la cámara
let scannerActive = false;

$('#cameraModal').on('shown.bs.modal', function () {
    if (!scannerActive) {
        Quagga.init({
            inputStream: {
                name: "Live",
                type: "LiveStream",
                target: document.querySelector('#interactive'),
                constraints: {
                    facingMode: "environment",
                    aspectRatio: { min: 1, max: 2 }
                },
            },
            locator: {
                patchSize: "medium",
                halfSample: true
            },
            numOfWorkers: 2,
            decoder: {
                readers: ["ean_reader", "ean_8_reader", "code_128_reader", "code_39_reader", "code_39_vin_reader", "codabar_reader", "upc_reader", "upc_e_reader"]
            },
            locate: true
        }, function(err) {
            if (err) {
                console.error(err);
                $('#result').text('Error al iniciar la cámara: ' + err.message).show();
                return;
            }
            scannerActive = true;
            Quagga.start();
        });

        Quagga.onDetected(function(result) {
            if (result.codeResult.code) {
                const codigo = result.codeResult.code;
                $('#result').text('Código detectado: ' + codigo).show();
                buscarProductoPorCodigo(codigo);
                
                // Reproducir sonido de confirmación
                const audio = new Audio('assets/sounds/beep.mp3');
                audio.play();
            }
        });
    }
});

$('#cameraModal').on('hidden.bs.modal', function () {
    if (scannerActive) {
        Quagga.stop();
        scannerActive = false;
    }
});

// Función para buscar producto por código (existente)
function buscarProductoPorCodigo(codigo) {
    fetch(`index.php?action=buscadorproducto&codigo=${codigo}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const articulo = data.articulo;
                const tbody = document.querySelector('table tbody');
                const filas = tbody.querySelectorAll('tr');
                let productoExistente = false;

                for (let fila of filas) {
                    const articuloId = fila.querySelector('input[name="articulo_[]"]').value;
                    const unidadId = fila.querySelector('input[name="unidad_[]"]').value;

                    // Obtener el almacén ya sea de un select o de un input oculto
                    let almacenId;
                    const selectAlmacen = fila.querySelector('select[name="almacen_[]"]');
                    const inputAlmacen = fila.querySelector('input[name="almacen_[]"]');
                    
                    if (selectAlmacen) {
                        almacenId = selectAlmacen.value;
                    } else if (inputAlmacen) {
                        almacenId = inputAlmacen.value;
                    }
                    
                    if (articuloId == articulo.id && 
                        almacenId == articulo.almacen_id && 
                        unidadId == articulo.unidad_id) {
                        
                        const cantidadInput = fila.querySelector('input[name="cantidad_[]"]');
                        const nuevaCantidad = parseInt(cantidadInput.value) + 1;
                        cantidadInput.value = nuevaCantidad;
                        
                        const precio = parseFloat(fila.querySelector('input[name="precioProducto_[]"]').value);
                        const subtotal = nuevaCantidad * precio;
                        fila.querySelector('.subtotalProducto').textContent = subtotal.toFixed(2) + ' MXN';
                        
                        // Mostrar notificación sutil
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        });

                        Toast.fire({
                            icon: 'success',
                            title: `Cantidad actualizada: ${nuevaCantidad}`
                        });
                        
                        productoExistente = true;
                        break;
                    }
                }

                if (!productoExistente) {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td><input type="hidden" name="articulo_[]" value="${articulo.id}" />${articulo.nombre}</td>
                        <td><input type="hidden" name="unidad_[]" value="${articulo.unidad_id}">${articulo.unidad_nombre}</td>
                        <td><input type="number" name="cantidad_[]" value="1" style="width: 50px;" /></td>
                        <td><input type="number" name="precioProducto_[]" value="${articulo.precio_venta}" style="width: 60px;" /></td>
                        <td class="subtotalProducto">${articulo.precio_venta} MXN</td>
                        <td><input type="hidden" name="cantidad_unidad_[]" value="${articulo.cantidad_unidad}" />${articulo.precio_venta}</td>
                        <td>
                            <select name="almacen_[]" class="form-select form-select-sm" style="width: 150px;">
                                <option value="${articulo.almacen_id}" selected>${articulo.almacen_nombre}</option>
                            </select>
                        </td>
                        <td><button type="button" class="btn btn-danger btn-sm btnEliminar"><i class="ri-delete-bin-2-line"></i></button></td>
                    `;
                    tbody.appendChild(row);

                    // Cargar los almacenes disponibles para este producto
                    cargarAlmacenesDisponibles(articulo.id, row);
                }

                // Actualizar totales
                calcularTotales();

                // Activar el botón de registro inmediatamente
                const addBtn = document.getElementById('add-btn');
                if (addBtn) {
                    addBtn.removeAttribute('disabled');
                    addBtn.classList.remove('disabled');
                    addBtn.style.opacity = '1';
                    addBtn.style.cursor = 'pointer';
                    addBtn.style.pointerEvents = 'auto';
                }

                // Reproducir sonido de confirmación
                try {
                const audio = new Audio('assets/sounds/beep.mp3');
                    audio.play().catch(error => {
                        console.log('No se pudo reproducir el sonido:', error);
                    });
                } catch (error) {
                    console.log('Error al crear el audio:', error);
                }

                // Limpiar todos los campos
                limpiarCampos();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message || 'Producto no encontrado'
                });
            }
        });
}

// ... rest of existing code ...
</script>

<style>
#interactive.viewport {
    position: relative;
    width: 100%;
    height: 300px;
    overflow: hidden;
    text-align: center;
}

#interactive.viewport canvas, video {
    width: 100%;
    height: 100%;
}

#interactive.viewport canvas.drawingBuffer, video.drawingBuffer {
    position: absolute;
    top: 0;
    left: 0;
}
</style>

<div id="scanner-container" style="display: none;">
    <div class="scanner-wrapper">
        <video id="barcode-scanner"></video>
        <div class="scanner-overlay">
            <div class="scanner-guide"></div>
        </div>
    </div>
</div>

<!-- Incluir ZXing -->
<script src="https://unpkg.com/@zxing/library@latest"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const codeReader = new ZXing.BrowserMultiFormatReader();
    const video = document.getElementById('barcode-scanner');
    const scannerContainer = document.getElementById('scanner-container');
    const startScanButton = document.getElementById('start-scan');
    const stopScanButton = document.getElementById('stop-scan');
    const inputField = document.getElementById('codigo-barras');

    let scanning = false;
    let typingTimer;
    const typingDelay = 300;
    let lastScannedCode = '';
    let lastScanTime = 0;
    const scanCooldown = 500; // 500ms de espera entre escaneos

    startScanButton.addEventListener('click', () => {
        if (!scanning) startScan();
    });

    stopScanButton.addEventListener('click', () => {
        if (scanning) stopScan();
    });

    function startScan() {
        navigator.mediaDevices.getUserMedia({ 
            video: { 
                facingMode: 'environment',
                width: { ideal: 1280 },
                height: { ideal: 720 }
            } 
        })
        .then((stream) => {
            video.srcObject = stream;
            video.play();
            scannerContainer.style.display = 'block';
            startScanButton.style.display = 'none';
            stopScanButton.style.display = 'block';
            scanning = true;

            // Iniciar el escaneo continuo
            codeReader.decodeFromVideoDevice(null, video, (result, err) => {
                if (result) {
                    const currentTime = Date.now();
                    if (currentTime - lastScanTime >= scanCooldown) {
                        try {
                            const qrData = JSON.parse(result.text);
                            inputField.value = qrData.Codigo || result.text;
                        } catch (e) {
                            inputField.value = result.text;
                        }
                        
                        // Buscar y agregar el producto sin verificar el último código escaneado
                        buscarProductoPorCodigo(inputField.value);
                        lastScanTime = currentTime;
                        
                        // Efecto visual de escaneo exitoso
                        const guide = document.querySelector('.scanner-guide');
                        guide.style.background = 'rgba(0, 255, 0, 0.5)';
                        setTimeout(() => {
                            guide.style.background = 'rgba(255, 255, 255, 0.5)';
                        }, 500);
                    }
                } else if (err && !(err instanceof ZXing.NotFoundException)) {
                    console.error("Error durante el escaneo:", err);
                }
            });
        })
        .catch((err) => {
            console.error("Error accediendo a la cámara:", err);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudo acceder a la cámara. Por favor, verifica los permisos.'
            });
        });
    }

    function stopScan() {
        scanning = false;
        if (video.srcObject) {
            video.srcObject.getTracks().forEach(track => track.stop());
        }
        scannerContainer.style.display = 'none';
        startScanButton.style.display = 'block';
        stopScanButton.style.display = 'none';
        codeReader.reset();
        lastScannedCode = '';
        lastScanTime = 0;
    }

    // Configuración para la pistola láser
    inputField.addEventListener('input', function() {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(() => {
            const codigo = inputField.value.trim();
            if (codigo !== '') {
                buscarProductoPorCodigo(codigo);
            }
        }, typingDelay);
    });
});
</script>

<style>
#scanner-container {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 1050;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    padding: 10px;
    display: none;
    max-width: 250px;
    transition: all 0.3s ease;
}

.scanner-wrapper {
    position: relative;
    width: 100%;
    border-radius: 10px;
    overflow: hidden;
}

#barcode-scanner {
    width: 100%;
    height: 150px;
    object-fit: cover;
    border-radius: 8px;
}

.scanner-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
}

.scanner-guide {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 80%;
    height: 2px;
    background: rgba(255, 255, 255, 0.8);
    box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);
    animation: scan 2s infinite linear;
}

.scanner-guide:before,
.scanner-guide:after {
    content: '';
    position: absolute;
    width: 12px;
    height: 12px;
    border: 2px solid #fff;
}

.scanner-guide:before {
    top: -6px;
    left: -6px;
    border-right: none;
    border-bottom: none;
}

.scanner-guide:after {
    bottom: -6px;
    right: -6px;
    border-left: none;
    border-top: none;
}

@keyframes scan {
    0% { transform: translate(-50%, -50%) translateY(-30px); }
    50% { transform: translate(-50%, -50%) translateY(30px); }
    100% { transform: translate(-50%, -50%) translateY(-30px); }
}

#stop-scan {
    position: absolute;
    top: -8px;
    right: -8px;
    z-index: 1051;
    background: #fff;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    border: none;
    color: #dc3545;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s ease;
}

#stop-scan:hover {
    transform: scale(1.1);
    background: #dc3545;
    color: #fff;
}

.scanner-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
    padding: 0 5px;
}

.scanner-title {
    font-size: 13px;
    font-weight: 600;
    color: #333;
    margin: 0;
}

.scanner-status {
    font-size: 11px;
    color: #28a745;
    display: flex;
    align-items: center;
}

.scanner-status:before {
    content: '';
    display: inline-block;
    width: 6px;
    height: 6px;
    background: #28a745;
    border-radius: 50%;
    margin-right: 4px;
    animation: pulse 1.5s infinite linear;
}

@keyframes pulse {
    0% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.2); opacity: 0.7; }
    100% { transform: scale(1); opacity: 1; }
}
</style>

<div id="scanner-container">
    <div class="scanner-header">
        <h6 class="scanner-title">Escáner de Códigos</h6>
        <span class="scanner-status">Activo</span>
    </div>
    <div class="scanner-wrapper">
        <video id="barcode-scanner"></video>
        <div class="scanner-overlay">
            <div class="scanner-guide"></div>
        </div>
        <button type="button" id="stop-scan" class="btn-close" aria-label="Cerrar"></button>
    </div>
</div>

<script>
function calcularTotales() {
    let subtotal = 0;
    let total = 0;
    let igv = 0;
    let descuento = parseFloat($('input[name="descuento"]').val()) || 0;
    let aplicarIgv = $('#igv').is(':checked');

    // Calcular subtotal sumando todos los productos
    $('table tbody tr').each(function() {
        let cantidad = parseFloat($(this).find('input[name="cantidad_[]"]').val()) || 0;
        let precio = parseFloat($(this).find('input[name="precioProducto_[]"]').val()) || 0;
        let subtotalProducto = cantidad * precio;
        subtotal += subtotalProducto;
    });

    // Aplicar descuento
    subtotal = subtotal - descuento;

    // Calcular IGV si está activado
    if (aplicarIgv) {
        const TASA_IVA = <?= floatval($tasa_iva) ?> / 100;
        igv = subtotal * TASA_IVA;
        total = subtotal + igv;
    } else {
        total = subtotal;
    }

    // Actualizar los campos en el formulario
    $('input[name="subtotal"]').val(subtotal.toFixed(2));
    $('input[name="igv"]').val(igv.toFixed(2));
    $('input[name="total"]').val(total.toFixed(2));

    // Actualizar el estado del botón
    actualizarEstadoBoton();
}

// Evento para actualizar totales cuando cambia el descuento
$('input[name="descuento"]').on('input', function() {
    calcularTotales();
});

// Evento para actualizar totales cuando cambia el IGV
$('#igv').change(function() {
    calcularTotales();
});

// Evento para actualizar totales cuando cambian cantidades o precios
$(document).on('input', 'input[name="cantidad_[]"], input[name="precioProducto_[]"]', function() {
    var moneda = $('select[name="tipo_moneda"] option:selected').text();
    let $row = $(this).closest('tr');
    let cantidad = parseFloat($row.find('input[name="cantidad_[]"]').val()) || 0;
    let precio = parseFloat($row.find('input[name="precioProducto_[]"]').val()) || 0;
    $row.find('.subtotalProducto').text((cantidad * precio).toFixed(2) + moneda);
    calcularTotales();
});

// Evento para actualizar totales cuando se elimina un producto
$(document).on('click', '.btnEliminar', function() {
    $(this).closest('tr').remove();
    calcularTotales();
});
</script>