<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <!-- ***************************************************** -->
                    <div class="modal fade" id="showModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-body text-center p-5">
                                    <div class="mb-4">
                                        <lord-icon
                                            src="https://cdn.lordicon.com/guothkao.json"
                                            trigger="loop"
                                            delay="2000"
                                            style="width:120px;height:120px">
                                        </lord-icon>
                                    </div>
                                    <h4 class="mb-3">Transferencia # <?php echo isset($_SESSION['numero_transferencia']) ? $_SESSION['numero_transferencia'] : ''; ?></h4>
                                    <div class="form-group">
                                        <label for="printOption" class="form-label">Elija el tipo del comprobante:</label>
                                        <select id="printOption" class="form-select">
                                            <option value="">Seleccionar documento</option>
                                            <option value="index.php?action=modelostransferencia&tid=<?php echo $_SESSION['numero_transferencia']; ?>">Ticket</option>
                                            <!-- <option value="factura.php">Factura</option> -->
                                        </select>
                                    </div>
                                    <div class="d-flex justify-content-center mt-4">
                                        <button type="button" class="btn btn-outline-secondary me-3" data-bs-dismiss="modal"><i class="ri-close-line me-1"></i>Cerrar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script>
                        document.getElementById('printOption').addEventListener('change', function() {
                            var selectedOption = this.value;
                            if (selectedOption) {
                                window.open(selectedOption, '_blank');
                            }
                        });
                    </script>
                    <?php   if (isset($_SESSION['numero_transferencia'])) {
                        unset($_SESSION['numero_transferencia']);
                        }
                        if (isset($_SESSION['show_modal']) && $_SESSION['show_modal']) {
                            echo '<script>$(document).ready(function() { $("#showModal").modal("show"); });</script>';
                            unset($_SESSION['show_modal']); 
                        }
                    ?>
                    <?php if (isset($_SESSION['success_message'])) : ?>
                        <script>
                            Swal.fire({
                                icon: "success",
                                title: "Éxito",
                                text: "<?php echo $_SESSION['success_message']; ?>",
                                timer: 1000,
                                showConfirmButton: true
                            });
                        </script>
                    <?php unset($_SESSION['success_message']); ?>
                    <?php endif; ?>
                    <!-- ************************************************************* -->
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0 text-white">Realizar transferencia</h5>
                        </div>
                        <div class="card-body">
                            <form enctype="multipart/form-data" class="tablelist-form" autocomplete="off" method="post" action="index.php?action=registro">
                                <div id="stock-resumen"></div>
                                <div class="row">
                                    <div class="col-md-4" style="display: none;">
                                        <label for="codigo-barras" class="form-label text-primary">Código de Barras</label>
                                        <div class="input-group">
                                            <input type="text" id="codigo-barras" class="form-control" placeholder="Escanea o ingresa manualmente" autofocus>
                                            <button class="btn btn-outline-secondary" type="button" id="start-scan">
                                                <i class="ri-camera-line"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" type="button" id="stop-scan" style="display: none;">
                                                <i class="ri-stop-circle-line"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="select-articulo" class="form-label text-primary">Artículo</label>
                                        <select name="articulo" id="select-articulo" class="form-select miSelect1 rounded-pill mb-3" aria-label="Default select example">
                                            <option value="">Seleccionar</option>
                                            <?php
                                            $articulos = ArticuloData::vercontenido();
                                            foreach ($articulos as $arti) { ?>
                                                <option value="<?= $arti->id; ?>"><?= $arti->nombre; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="almacen_origen" class="form-label text-primary">Almacén Origen</label>
                                        <select name="almacen_origen" id="almacen_origen" class="form-select miSelect1" aria-label="Default select example">
                                            <option value="">Seleccionar</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="almacen_destino" class="form-label text-primary">Almacén Destino</label>
                                        <select name="almacen_destino" id="almacen_destino" class="form-select miSelect1" aria-label="Default select example">
                                            <option value="">Seleccionar</option>
                                            <?php
                                            $bodegas = AlmacenData::vercontenido();
                                            foreach ($bodegas as $bode) { ?>
                                                <option value="<?= $bode->id; ?>"><?= $bode->nombre; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="cantidad" class="form-label text-primary">Cantidad</label>
                                        <input type="number" name="cantidad" id="cantidad" class="form-control" min="1">
                                    </div>
                                    <div class="col-md-2 d-flex align-items-end">
                                        <button id="btnAgregar" title="Agregar a la lista" class="btn btn-info btnguardar w-100">
                                            <i class="ri-add-line align-bottom me-1"></i> Agregar
                                        </button>
                                    </div>
                                </div>
                                <hr>
                                <div id="resumen-transferencia"></div>
                                <table class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%; font-size: 10px;">
                                    <thead class="bg-primary text-light">
                                        <tr>
                                            <th>Artículo</th>
                                            <th>Almacén Origen</th>
                                            <th>Almacén Destino</th>
                                            <th width="80px">Cantidad</th>
                                            <th width="5px"><i class="ri-delete-bin-2-line"></i></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                                <hr>
                                <div class="row">
                                    <div class="col-md-12">
                                        <label for="descripcion" class="form-label text-primary">Descripción de la transferencia</label>
                                        <textarea class="form-control" name="descripcion" rows="2" placeholder="Ingrese una descripción opcional de la transferencia"></textarea>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end mt-3">
                                    <input type="hidden" name="actions" value="41">
                                    <button type="submit" class="btn btn-primary" id="add-btn">
                                        <i class="ri-save-line align-bottom me-1"></i> Registrar Transferencia
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Función para buscar producto por código
    function buscarProductoPorCodigo(codigo) {
        fetch(`index.php?action=buscadorproducto&codigo=${codigo}`)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const articulo = data.articulo;
                    $('#select-articulo').val(articulo.id).trigger('change');
                    cargarAlmacenesOrigen(articulo.id);
                    
                    // Reproducir sonido de confirmación
                    const audio = new Audio('assets/sounds/beep.mp3');
                    audio.play();
                    
                    // Mostrar notificación
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 1500,
                        timerProgressBar: true
                    });

                    Toast.fire({
                        icon: 'success',
                        title: 'Producto encontrado'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'Producto no encontrado'
                    });
                }
            });
    }

    // Función para cargar almacenes origen
    function cargarAlmacenesOrigen(articuloId) {
        fetch(`index.php?action=apicantidadporalmacen1&producto_id=${articuloId}`)
            .then(response => response.json())
            .then(data => {
                const selectAlmacenOrigen = $('#almacen_origen');
                selectAlmacenOrigen.empty();
                selectAlmacenOrigen.append('<option value="">Seleccionar almacén origen</option>');
                
                if (data && Array.isArray(data) && data.length > 0) {
                    let totalStock = 0;
                    data.forEach(almacen => {
                        if (almacen.total_almacen > 0) {
                            selectAlmacenOrigen.append(`<option value="${almacen.id_almacen}" data-stock="${almacen.total_almacen}">${almacen.nombre_almacen} - (${almacen.total_almacen} disponible)</option>`);
                            totalStock += parseInt(almacen.total_almacen);
                        }
                    });
                    
                    // Mostrar resumen de stock total
                    $('#stock-resumen').html(`<div class="alert alert-info">
                        <i class="ri-information-line me-1"></i>
                        Stock total disponible: ${totalStock} unidades
                    </div>`);
                    
                    if (selectAlmacenOrigen.find('option').length <= 1) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Sin stock',
                            text: 'El producto no tiene stock en ningún almacén'
                        });
                    }
                } else {
                    $('#stock-resumen').html('');
                    Swal.fire({
                        icon: 'warning',
                        title: 'Sin stock',
                        text: 'El producto no tiene stock en ningún almacén'
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Ocurrió un error al cargar los almacenes'
                });
            });
    }

    // Evento cuando se selecciona un artículo
    $('#select-articulo').on('change', function() {
        const articuloId = $(this).val();
        if (articuloId) {
            cargarAlmacenesOrigen(articuloId);
            $('#almacen_origen').prop('disabled', false);
        } else {
            $('#almacen_origen').empty().append('<option value="">Seleccionar almacén origen</option>').prop('disabled', true);
            $('#almacen_destino').val('');
        }
    });

    // Evento para el escáner de código de barras
    document.getElementById('codigo-barras').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            const codigo = this.value.trim();
            if (codigo) {
                buscarProductoPorCodigo(codigo);
                this.value = '';
            }
        }
    });

    // Evento para agregar producto a la tabla
    $('#btnAgregar').on('click', function(e) {
        e.preventDefault();

        const articulo = $('#select-articulo').val();
        const articuloNombre = $('#select-articulo option:selected').text();
        const almacenOrigen = $('#almacen_origen').val();
        const almacenOrigenNombre = $('#almacen_origen option:selected').text();
        const almacenDestino = $('#almacen_destino').val();
        const almacenDestinoNombre = $('#almacen_destino option:selected').text();
        const cantidad = parseInt($('#cantidad').val());

        // Obtener el stock disponible del almacén seleccionado
        const stockDisponible = parseInt($('#almacen_origen option:selected').data('stock'));

        if (!articulo || !almacenOrigen || !almacenDestino || !cantidad) {
            Swal.fire({
                icon: 'warning',
                title: 'Campos incompletos',
                text: 'Por favor complete todos los campos'
            });
            return;
        }

        if (almacenOrigen === almacenDestino) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'El almacén de origen y destino no pueden ser el mismo'
            });
            return;
        }

        if (cantidad <= 0) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'La cantidad debe ser mayor a cero'
            });
            return;
        }

        if (cantidad > stockDisponible) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: `La cantidad a transferir (${cantidad}) excede el stock disponible (${stockDisponible}) en el almacén de origen`
            });
            return;
        }

        // Verificar si el producto ya está en la tabla
        const productoExistente = $(`tr[data-articulo="${articulo}"][data-origen="${almacenOrigen}"][data-destino="${almacenDestino}"]`);
        if (productoExistente.length > 0) {
            Swal.fire({
                icon: 'question',
                title: 'Producto existente',
                text: '¿Desea actualizar la cantidad del producto existente?',
                showCancelButton: true,
                confirmButtonText: 'Sí, actualizar',
                cancelButtonText: 'No, mantener'
            }).then((result) => {
                if (result.isConfirmed) {
                    const inputCantidad = productoExistente.find('input[name="cantidad_[]"]');
                    const cantidadActual = parseInt(inputCantidad.val());
                    const nuevaCantidad = cantidadActual + cantidad;
                    
                    if (nuevaCantidad > stockDisponible) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: `La cantidad total (${nuevaCantidad}) excede el stock disponible (${stockDisponible})`
                        });
                        return;
                    }
                    
                    inputCantidad.val(nuevaCantidad);
                    actualizarResumen();
                }
            });
            return;
        }

        const newRow = `
            <tr data-articulo="${articulo}" data-origen="${almacenOrigen}" data-destino="${almacenDestino}">
                <td><input type="hidden" name="articulo_[]" value="${articulo}" />${articuloNombre}</td>
                <td><input type="hidden" name="almacen_origen_[]" value="${almacenOrigen}" />${almacenOrigenNombre}</td>
                <td><input type="hidden" name="almacen_destino_[]" value="${almacenDestino}" />${almacenDestinoNombre}</td>
                <td><input type="number" name="cantidad_[]" value="${cantidad}" style="width: 50px;" min="1" max="${stockDisponible}" class="cantidad-input" /></td>
                <td><button type="button" class="btn btn-danger btn-sm btnEliminar"><i class="ri-delete-bin-2-line"></i></button></td>
            </tr>
        `;

        $('table tbody').append(newRow);
        actualizarResumen();

        // Limpiar campos
        $('#select-articulo').val('').trigger('change');
        $('#almacen_destino').val('').trigger('change');
        $('#almacen_origen').val('');
        $('#cantidad').val('');
        $('#codigo-barras').val('').focus();
    });

    // Evento para eliminar fila
    $(document).on('click', '.btnEliminar', function() {
        $(this).closest('tr').remove();
        actualizarResumen();
    });

    // Función para actualizar el resumen
    function actualizarResumen() {
        let totalProductos = 0;
        let totalUnidades = 0;
        
        $('table tbody tr').each(function() {
            totalProductos++;
            totalUnidades += parseInt($(this).find('.cantidad-input').val());
        });
        
        $('#resumen-transferencia').html(`
            <div class="alert alert-primary">
                <i class="ri-information-line me-1"></i>
                Resumen: ${totalProductos} producto(s) - ${totalUnidades} unidad(es) a transferir
            </div>
        `);

        // Habilitar/deshabilitar el botón de registro
        const btnRegistrar = $('#add-btn');
        if (totalProductos > 0) {
            btnRegistrar.prop('disabled', false);
            btnRegistrar.removeClass('btn-secondary').addClass('btn-primary');
        } else {
            btnRegistrar.prop('disabled', true);
            btnRegistrar.removeClass('btn-primary').addClass('btn-secondary');
        }
    }

    // Evento para validar cambios en las cantidades
    $(document).on('change', '.cantidad-input', function() {
        const stockDisponible = parseInt($(this).closest('tr').find('input[name="almacen_origen_[]"]').val());
        const cantidad = parseInt($(this).val());
        
        if (cantidad > stockDisponible) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: `La cantidad (${cantidad}) excede el stock disponible (${stockDisponible})`
            });
            $(this).val(stockDisponible);
        }
        
        actualizarResumen();
    });

    // Inicializar el select de almacén origen como deshabilitado
    $('#almacen_origen').prop('disabled', true);

    // Inicializar el botón como deshabilitado
    $('#add-btn').prop('disabled', true).removeClass('btn-primary').addClass('btn-secondary');
});
</script>

<!-- Incluir ZXing -->
<script src="https://unpkg.com/@zxing/library@latest"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const codeReader = new ZXing.BrowserMultiFormatReader();
    const video = document.getElementById('barcode-scanner');
    const scannerContainer = document.getElementById('scanner-container');
    const startScanButton = document.getElementById('start-scan');
    const stopScanButton = document.getElementById('stop-scan');
    const inputField = document.getElementById('codigo-barras');

    let scanning = false;
    let typingTimer;
    const typingDelay = 300;
    let lastScannedCode = '';
    let lastScanTime = 0;
    const scanCooldown = 1000;

    startScanButton.addEventListener('click', () => {
        if (!scanning) startScan();
    });

    stopScanButton.addEventListener('click', () => {
        if (scanning) stopScan();
    });

    function startScan() {
        navigator.mediaDevices.getUserMedia({ 
            video: { 
                facingMode: 'environment',
                width: { ideal: 1280 },
                height: { ideal: 720 }
            } 
        })
        .then((stream) => {
            video.srcObject = stream;
            video.play();
            scannerContainer.style.display = 'block';
            startScanButton.style.display = 'none';
            stopScanButton.style.display = 'block';
            scanning = true;

            codeReader.decodeFromVideoDevice(null, video, (result, err) => {
                if (result) {
                    const currentTime = Date.now();
                    if (currentTime - lastScanTime >= scanCooldown) {
                        try {
                            const qrData = JSON.parse(result.text);
                            inputField.value = qrData.Codigo || result.text;
                        } catch (e) {
                            inputField.value = result.text;
                        }
                        
                        buscarProductoPorCodigo(inputField.value);
                        lastScanTime = currentTime;
                    }
                } else if (err && !(err instanceof ZXing.NotFoundException)) {
                    console.error("Error durante el escaneo:", err);
                }
            });
        })
        .catch((err) => {
            console.error("Error accediendo a la cámara:", err);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudo acceder a la cámara. Por favor, verifica los permisos.'
            });
        });
    }

    function stopScan() {
        scanning = false;
        if (video.srcObject) {
            video.srcObject.getTracks().forEach(track => track.stop());
        }
        scannerContainer.style.display = 'none';
        startScanButton.style.display = 'block';
        stopScanButton.style.display = 'none';
        codeReader.reset();
        lastScannedCode = '';
        lastScanTime = 0;
    }
});
</script>

<style>
#scanner-container {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 1050;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    padding: 10px;
    display: none;
    max-width: 250px;
    transition: all 0.3s ease;
}

.scanner-wrapper {
    position: relative;
    width: 100%;
    border-radius: 10px;
    overflow: hidden;
}

#barcode-scanner {
    width: 100%;
    height: 150px;
    object-fit: cover;
    border-radius: 8px;
}

.scanner-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
}

.scanner-guide {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 80%;
    height: 2px;
    background: rgba(255, 255, 255, 0.8);
    box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);
    animation: scan 2s infinite linear;
}

.scanner-guide:before,
.scanner-guide:after {
    content: '';
    position: absolute;
    width: 12px;
    height: 12px;
    border: 2px solid #fff;
}

.scanner-guide:before {
    top: -6px;
    left: -6px;
    border-right: none;
    border-bottom: none;
}

.scanner-guide:after {
    bottom: -6px;
    right: -6px;
    border-left: none;
    border-top: none;
}

@keyframes scan {
    0% { transform: translate(-50%, -50%) translateY(-30px); }
    50% { transform: translate(-50%, -50%) translateY(30px); }
    100% { transform: translate(-50%, -50%) translateY(-30px); }
}

#stop-scan {
    position: absolute;
    top: -8px;
    right: -8px;
    z-index: 1051;
    background: #fff;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    border: none;
    color: #dc3545;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s ease;
}

#stop-scan:hover {
    transform: scale(1.1);
    background: #dc3545;
    color: #fff;
}
</style>

<div id="scanner-container">
    <div class="scanner-wrapper">
        <video id="barcode-scanner"></video>
        <div class="scanner-overlay">
            <div class="scanner-guide"></div>
        </div>
        <button type="button" id="stop-scan" class="btn-close" aria-label="Cerrar"></button>
    </div>
</div>