<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <!-- Espacio para un título si lo requieres -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                <?php
                                $base = Database::getInstance();
                                $conn = $base->getConnection();
                                $sql = "
                                SELECT p.id, p.articulo, p.cantidad, p.precio, p.total, p.accion, p.fecha, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color
                                FROM proceso p
                                JOIN articulo a ON p.articulo = a.id
                                ";

                                $result = $conn->query($sql);

                                $inventory_duration = [];
                                $profit_data = [];
                                $sales_data = [];

                                if ($result->num_rows > 0) {
                                    while($row = $result->fetch_assoc()) {
                                        $date = new DateTime($row['fecha']);
                                        $article = $row['articulo'];
                                        $quantity = $row['cantidad'];

                                        if ($row['accion'] == 1) { // Entrada
                                            if (!isset($inventory_duration[$article])) {
                                                $inventory_duration[$article] = [];
                                            }
                                            $inventory_duration[$article]['entrada'] = $date->getTimestamp();
                                        } elseif ($row['accion'] == 2) { // Salida
                                            if (isset($inventory_duration[$article]['entrada'])) {
                                                $entrada = $inventory_duration[$article]['entrada'];
                                                $salida = $date->getTimestamp();
                                                $duration = ($salida - $entrada) / (60 * 60 * 24); // Duración en días

                                                if (!isset($inventory_duration[$article]['duraciones'])) {
                                                    $inventory_duration[$article]['duraciones'] = [];
                                                }
                                                $inventory_duration[$article]['duraciones'][] = $duration;
                                            }

                                            if (!isset($profit_data[$article])) {
                                                $profit_data[$article] = ['price' => 0, 'quantity' => 0];
                                            }

                                            $profit_data[$article]['price'] = $row['precio'];
                                            $profit_data[$article]['quantity'] += $quantity;

                                            if (!isset($sales_data[$article])) {
                                                $sales_data[$article] = [];
                                            }
                                            $sales_data[$article][] = ['date' => $date->format('Y-m-d'), 'quantity' => $quantity];
                                        }
                                    }
                                }

                                $conn->close();

                                echo "<script>console.log('Inventory Duration:', " . json_encode($inventory_duration) . ");</script>";
                                echo "<script>console.log('Profit Data:', " . json_encode($profit_data) . ");</script>";
                                echo "<script>console.log('Sales Data:', " . json_encode($sales_data) . ");</script>";
                                echo "<script>var inventoryDuration = " . json_encode($inventory_duration) . ";</script>";
                                echo "<script>var profitData = " . json_encode($profit_data) . ";</script>";
                                echo "<script>var salesData = " . json_encode($sales_data) . ";</script>";
                                ?>

                                <script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
                                <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                                <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns"></script>
                                <canvas id="combinedChart" width="400" height="200"></canvas>

                                <script>
                                    function calculateAverageDuration(data) {
                                        const result = {};
                                        for (const article in data) {
                                            const durations = data[article].duraciones;
                                            if (durations && durations.length > 0) {
                                                result[article] = durations.reduce((a, b) => a + b, 0) / durations.length;
                                            } else {
                                                result[article] = 0;
                                            }
                                        }
                                        return result;
                                    }

                                    function prepareCombinedData(inventoryDuration, profitData) {
                                        const articles = Object.keys(inventoryDuration);
                                        const avgDurations = calculateAverageDuration(inventoryDuration);
                                        const dataset = articles.map(article => {
                                            const totalProfit = profitData[article]['price'] * profitData[article]['quantity'];
                                            return {
                                                label: `Artículo ${article}`,
                                                data: [{
                                                    x: avgDurations[article],
                                                    y: totalProfit,
                                                    r: 5 // Radio de la burbuja, se puede ajustar según sea necesario
                                                }],
                                                backgroundColor: totalProfit > 1000 ? 'rgba(75, 192, 192, 0.2)' : 'rgba(255, 99, 132, 0.2)',
                                                borderColor: totalProfit > 1000 ? 'rgba(75, 192, 192, 1)' : 'rgba(255, 99, 132, 1)',
                                            };
                                        });

                                        return dataset;
                                    }

                                    function checkRentability(profitData, salesData) {
                                        const rentability = {};
                                        for (const article in profitData) {
                                            const totalQuantity = salesData[article].reduce((sum, sale) => sum + sale.quantity, 0);
                                            const price = profitData[article]['price'];
                                            rentability[article] = (totalQuantity > 20 && price > 10) ? 'Rentable' : 'No Rentable';
                                        }
                                        return rentability;
                                    }

                                    async function predictData(inventoryDuration, profitData, salesData) {
                                        const avgDurations = calculateAverageDuration(inventoryDuration);
                                        const articles = Object.keys(avgDurations);

                                        const xData = [];
                                        const yData = [];

                                        articles.forEach(article => {
                                            xData.push(avgDurations[article]);
                                            yData.push(profitData[article]['price'] * profitData[article]['quantity']);
                                        });

                                        const xTensor = tf.tensor2d(xData, [xData.length, 1]);
                                        const yTensor = tf.tensor2d(yData, [yData.length, 1]);

                                        const model = tf.sequential();
                                        model.add(tf.layers.dense({inputShape: [1], units: 1}));

                                        model.compile({optimizer: 'sgd', loss: 'meanSquaredError'});

                                        await model.fit(xTensor, yTensor, {epochs: 100});

                                        const predictions = [];
                                        const currentDate = new Date();
                                        for (let i = 1; i <= 6; i++) {
                                            const futureDate = new Date(currentDate);
                                            futureDate.setMonth(currentDate.getMonth() + i);
                                            const durationPrediction = await model.predict(tf.tensor2d([i * 30], [1, 1])).array();
                                            const profitPrediction = await model.predict(tf.tensor2d([i * 30], [1, 1])).array();

                                            // Ajuste para agregar variabilidad a las predicciones
                                            const variabilityFactor = Math.random() * 0.2 + 0.9; // Variabilidad entre 0.9 y 1.1
                                            const adjustedProfitPrediction = profitPrediction[0][0] * variabilityFactor;

                                            predictions.push({
                                                x: i * 30,
                                                y: adjustedProfitPrediction,
                                                r: 5, // Radio de la burbuja, se puede ajustar según sea necesario
                                                date: futureDate.toISOString().split('T')[0] // Formato de fecha ISO
                                            });
                                        }

                                        return predictions;
                                    }

                                    async function main(predict = false) {
                                        const combinedDataset = prepareCombinedData(inventoryDuration, profitData);
                                        const rentability = checkRentability(profitData, salesData);

                                        const ctx = document.getElementById('combinedChart').getContext('2d');
                                        const combinedChart = new Chart(ctx, {
                                            type: 'bubble',
                                            data: {
                                                datasets: combinedDataset
                                            },
                                            options: {
                                                scales: {
                                                    x: {
                                                        title: {
                                                            display: true,
                                                            text: 'Duración Promedio en Inventario (días)'
                                                        }
                                                    },
                                                    y: {
                                                        title: {
                                                            display: true,
                                                            text: 'Rentabilidad'
                                                        }
                                                    }
                                                },
                                                plugins: {
                                                tooltip: {
                                                    callbacks: {
                                                        label: function(context) {
                                                            const duration = Math.round(context.raw.x);
                                                            const profit = Math.round(context.raw.y);
                                                            const rentable = profit > 500 ? 'Rentable' : 'No Rentable';
                                                            const date = context.raw.date;
                                                            const articleName = context.dataset.label; // Nombre del artículo
                                                            return `Artículo: ${articleName}\nDuración: ${duration} días`;
                                                        }
                                                    }
                                                }
                                            }

                                            }
                                        });

                                        if (predict) {
                                            const predictions = await predictData(inventoryDuration, profitData, salesData);

                                            const predictionDataset = {
                                                label: 'Predicciones',
                                                data: predictions.map(prediction => ({
                                                    x: prediction.x,
                                                    y: prediction.y,
                                                    r: prediction.r,
                                                    date: prediction.date
                                                })),
                                                fill: false,
                                                borderColor: 'rgba(255, 99, 132, 1)',
                                                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                                hidden: true // Inicialmente oculto
                                            };

                                            combinedChart.data.datasets.push(predictionDataset);
                                            combinedChart.update();

                                            const predictionToggle = document.createElement('button');
                                            predictionToggle.textContent = 'Mostrar/Ocultar Predicciones';
                                            predictionToggle.onclick = () => {
                                                const dataset = combinedChart.data.datasets.find(ds => ds.label === 'Predicciones');
                                                if (dataset) {
                                                    dataset.hidden = !dataset.hidden;
                                                    combinedChart.update();
                                                }
                                            };

                                            document.body.appendChild(predictionToggle);
                                        }
                                    }

                                    // Cambia el valor de "true" a "false" si no deseas hacer predicciones.
                                    main(true);
                                </script>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 