<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card shadow-lg rounded-3 border-0">
                        <div class="card-header bg-primary bg-gradient text-white py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0 text-white fw-bold">
                                    <i class="fas fa-exchange-alt me-2"></i> Reporte de Movimientos Compra y Venta
                                </h4>
                            </div>
                        </div>
                        <div class="card-body p-4">
                            <div class="row g-3 mb-4">
                                <div class="col-md-2">
                                    <label for="start" class="form-label fw-bold text-primary">
                                        <i class="far fa-calendar-alt me-2"></i>Fecha Inicio
                                    </label>
                                    <input type="date" name="start" id="start" class="form-control form-control-sm shadow-sm rounded-pill">
                                </div>
                                <div class="col-md-2">
                                    <label for="end" class="form-label fw-bold text-primary">
                                        <i class="far fa-calendar-alt me-2"></i>Fecha Final
                                    </label>
                                    <input type="date" name="end" id="end" class="form-control form-control-sm shadow-sm rounded-pill">
                                </div>
                                <div class="col-md-3">
                                    <label for="producto" class="form-label fw-bold text-primary">
                                        <i class="fas fa-box me-2"></i>Producto
                                    </label>
                                    <select name="producto" id="producto" class="form-select form-select-sm shadow-sm rounded-pill miSelect1">
                                        <option value="">Todos los productos</option>
                                        <?php 
                                        // Obtener lista de productos para el filtro
                                        $productos = ArticuloData::vercontenido();
                                        foreach($productos as $producto): 
                                        ?>
                                            <option value="<?= $producto->id; ?>"><?= htmlspecialchars($producto->nombre); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <div class="d-flex w-100">
                                        <button id="btn-filtrar" class="btn btn-primary btn-sm rounded-pill shadow-sm me-2">
                                            <i class="fas fa-filter me-1"></i> Filtrar
                                        </button>
                                        <button id="btn-limpiar" class="btn btn-outline-danger btn-sm rounded-pill shadow-sm">
                                            <i class="fas fa-broom me-1"></i> Limpiar
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <!-- Botones de exportación dinámicos -->
                                    <div class="d-flex w-100" id="export-buttons">
                                        <button id="btn-pdf-general" class="btn btn-danger btn-sm rounded-pill shadow-sm me-2 btn-export">
                                            <i class="fas fa-file-pdf me-1"></i> PDF General
                                        </button>
                                        <button id="btn-pdf-filtrado" class="btn btn-outline-danger btn-sm rounded-pill shadow-sm btn-export" style="display: none;">
                                            <i class="fas fa-file-pdf me-1"></i> PDF Filtrado
                                        </button>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="alert alert-info rounded-3 shadow-sm mb-4">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-info-circle fs-4 me-3"></i>
                                    <div>
                                        <h5 class="alert-heading mb-1">Instrucciones</h5>
                                        <p class="mb-0 small">Seleccione los filtros (fecha y/o producto) y presione 'Filtrar' para visualizar el reporte de compras y ventas.</p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="table-responsive">
                            <table id="customerTable1" class="table table-bordered table-striped align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th style="width: 100px;">Fecha</th>
                                        <th style="width: 80px;">Tipo</th>
                                        <th>Artículos</th>
                                        <th>Cantidad</th>
                                        <th>Saldo</th>
                                        <th>Stock</th>
                                        <th>Destino</th>
                                        <th>Precio Por Unidad</th>
                                        <th>Precio Total Por Artículo</th>
                                        <th>Subtotal</th>
                                        <th>Descuento</th>
                                        <th>IGV</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody id="resultados-body" class="small">
                                    <?php $operaciones = CompraData::vercontenido_reporte_nuevo(); ?>
                                    <?php foreach($operaciones as $operacion): ?>
                                        <?php 
                                            $id_operacion = $operacion->id;
                                            $tipo_operacion = $operacion->tipo_operacion;
                                            $detalles = ProcesoData::vercontenidos_nuevo($id_operacion, $tipo_operacion);
                                            $num_articulos = count($detalles);
                                        ?>
                                        <tr>
                                            <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>"><?= htmlspecialchars($operacion->fecha); ?></td>
                                            <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>">
                                                <span class="badge <?= $tipo_operacion === 'COMPRA' ? 'bg-success' : 'bg-danger'; ?>">
                                                    <i class="fas <?= $tipo_operacion === 'COMPRA' ? 'fa-plus' : 'fa-minus'; ?> me-1"></i>
                                                    <?= $tipo_operacion; ?>
                                                </span>
                                            </td>
                                            
                                            <?php if($num_articulos > 0): ?>
                                                <?php $first = true; ?>
                                                <?php foreach($detalles as $detalle): ?>
                                                    <?php if(!$first): ?>
                                                        <tr>
                                                    <?php endif; ?>
                                                    
                                                    <td><?= htmlspecialchars($detalle->articulos); ?></td>
                                                    <td>
                                                        <?php 
                                                            $cantidad_final = $detalle->cantidad / $detalle->cantidad_unidad;
                                                            echo number_format($cantidad_final) . " " . htmlspecialchars($detalle->unidades);
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php 
                                                            // Obtener saldo anterior POR ALMACÉN (antes de esta operación)
                                                            $saldo_anterior = ProcesoData::obtenerSaldoAnteriorPorAlmacen_nuevo(
                                                                $detalle->articulo, 
                                                                $detalle->almacen, 
                                                                $operacion->fecha,
                                                                $tipo_operacion,
                                                                $id_operacion
                                                            );
                                                            echo number_format($saldo_anterior) . " " . htmlspecialchars($detalle->unidades);
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php 
                                                            // Stock actual después de la operación
                                                            $stock_actual = ProcesoData::calcularStockDespuesOperacion(
                                                                $saldo_anterior, 
                                                                $cantidad_final, 
                                                                $tipo_operacion
                                                            );
                                                            $color_class = $stock_actual < 0 ? 'text-danger fw-bold' : '';
                                                            echo '<span class="' . $color_class . '">' . number_format($stock_actual) . " " . htmlspecialchars($detalle->unidades) . '</span>';
                                                        ?>
                                                    </td>
                                                    <td><?= htmlspecialchars($detalle->almacenes); ?></td>
                                                    <td><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($detalle->precio, 2); ?></td>
                                                    <td>
                                                        <?php 
                                                            $precio_total_articulo = $detalle->precio * $cantidad_final;
                                                            echo htmlspecialchars($operacion->simbolo) . ". " . number_format($precio_total_articulo, 2);
                                                        ?>
                                                    </td>
                                                    
                                                    <?php if($first): ?>
                                                        <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->subtotal, 2); ?></td>
                                                        <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->descuento, 2); ?></td>
                                                        <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->igv, 2); ?></td>
                                                        <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->total, 2); ?></td>
                                                    <?php endif; ?>
                                                    
                                                    <?php if(!$first): ?>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <?php $first = false; ?>
                                                <?php endforeach; ?> 
                                            <?php else: ?>
                                                <td>Sin artículos</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td>-</td>
                                                <td><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->subtotal, 2); ?></td>
                                                <td><?= htmlspecialchars($operacion->descuento, 2); ?></td>
                                                <td><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->igv, 2); ?></td>
                                                <td><?= htmlspecialchars($operacion->simbolo); ?>. <?= number_format($operacion->total, 2); ?></td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    let filtrosAplicados = false;
    
    // Función para mostrar/ocultar botones de PDF
    function togglePdfButtons() {
        if (filtrosAplicados) {
            $('#btn-pdf-general').hide();
            $('#btn-pdf-filtrado').show();
        } else {
            $('#btn-pdf-general').show();
            $('#btn-pdf-filtrado').hide();
        }
    }
    
    // Función para cargar datos con filtros
    function cargarDatos(fechaInicio = '', fechaFin = '', producto = '') {
        $.ajax({
            url: 'index.php?action=filtro_operaciones',
            type: 'POST',
            data: {
                start: fechaInicio,
                end: fechaFin,
                producto: producto
            },
            beforeSend: function() {
                $('#resultados-body').html('<tr><td colspan="13" class="text-center"><i class="fas fa-spinner fa-spin"></i> Cargando datos...</td></tr>');
            },
            success: function(response) {
                $('#resultados-body').html(response);
                // Actualizar estado de filtros
                filtrosAplicados = !!(fechaInicio || fechaFin || producto);
                togglePdfButtons();
            },
            error: function() {
                $('#resultados-body').html('<tr><td colspan="13" class="text-center text-danger">Error al cargar los datos</td></tr>');
            }
        });
    }

    // Filtrar al hacer clic en el botón
    $('#btn-filtrar').click(function() {
        const fechaInicio = $('#start').val();
        const fechaFin = $('#end').val();
        const producto = $('#producto').val();
        
        if (fechaInicio && fechaFin && fechaInicio > fechaFin) {
            alert('La fecha de inicio no puede ser mayor a la fecha final');
            return;
        }
        
        cargarDatos(fechaInicio, fechaFin, producto);
    });

    // Limpiar filtros
    $('#btn-limpiar').click(function() {
        $('#start').val('');
        $('#end').val('');
        $('#producto').val('');
        filtrosAplicados = false;
        cargarDatos();
    });

    // Generar PDF General
    $('#btn-pdf-general').click(function() {
        window.open('index.php?action=generar_pdf_operaciones&tipo=general', '_blank');
    });

    // Generar PDF Filtrado
    $('#btn-pdf-filtrado').click(function() {
        const fechaInicio = $('#start').val();
        const fechaFin = $('#end').val();
        const producto = $('#producto').val();
        
        let url = 'index.php?action=generar_pdf_operaciones&tipo=filtrado';
        if (fechaInicio) url += '&start=' + fechaInicio;
        if (fechaFin) url += '&end=' + fechaFin;
        if (producto) url += '&producto=' + producto;
        
        window.open(url, '_blank');
    });
    
    // Inicializar botones
    togglePdfButtons();
});
</script>