<?php 
// Definir variables al inicio
$operaciones = [];
$mostrarTabla = false;
$mostrarTodo = false;

// Verificar si se está mostrando todo
if (isset($_GET['mostrar_todo']) && $_GET['mostrar_todo'] == '1') {
    $operaciones = ClienteData::getAllClientes();
    $mostrarTabla = true;
    $mostrarTodo = true;
} 
// Verificar si hay filtro por fechas
elseif (isset($_GET['desde']) && isset($_GET['hasta'])) {
    if ($_GET['desde'] != "" && $_GET['hasta'] != "") {
        $operaciones = ClienteData::reporte1($_GET['desde'], $_GET['hasta'], 'cliente');
        $mostrarTabla = true;
    }
}
?>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/vfs_fonts.js"></script>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Reporte de Clientes por Rango de Fecha</h4>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <form id="filtroFechas">
                                        <div class="row align-items-end">
                                            <div class="col-md-4">
                                                <label for="desde" class="font-weight-bold">Desde:</label>
                                                <input type="date" name="desde" id="desde" class="form-control" value="<?php echo isset($_GET["desde"]) ? $_GET["desde"] : ''; ?>" required>
                                            </div>
                                            <div class="col-md-4">
                                                <label for="hasta" class="font-weight-bold">Hasta:</label>
                                                <input type="date" name="hasta" id="hasta" class="form-control" value="<?php echo isset($_GET["hasta"]) ? $_GET["hasta"] : ''; ?>" required>
                                            </div>
                                            <div class="col-md-4">
                                                <button type="submit" class="btn btn-success btn-block align-self-end">Procesar</button>
                                                <button type="button" id="reporteCompleto" class="btn btn-primary">Listar Todo</button>
                                                <div id="contenedor-btn-pdf">
                                                    <?php if ($mostrarTabla && count($operaciones) > 0) { ?>
                                                    <button type="button" id="generarPdf" class="btn btn-danger mt-2">
                                                        Generar PDF <?php echo $mostrarTodo ? '(Todos)' : '(Filtrados)'; ?>
                                                    </button>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body">
                                    <div id="tabla-contenedor">
                                    <?php 
                                    if ($mostrarTabla) {
                                        if (count($operaciones) > 0) { 
                                    ?>
                                    <table id="reportestable" class="table table-bordered dt-responsive nowrap table-striped align-middle"
                                    style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>Cliente</th>
                                                <th>Telefono</th>
                                                <th>Email</th>
                                                <th>Estado</th>
                                                <th>Fecha</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($operaciones as $data) { ?>
                                            <tr>
                                                <td><?= $data->nombre;?></td>
                                                <td><?= $data->telefono;?></td>
                                                <td><?= $data->email;?></td>
                                                <td>
                                                    <?php if ($data->estado == 1) { ?>
                                                        <i class="ri-check-line text-success"></i> 
                                                    <?php } else { ?>
                                                        <i class="ri-close-line text-danger"></i>
                                                    <?php } ?>
                                                </td>
                                                <td><?= $data->fecha;?></td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                    <?php } else {
                                        echo "<div class='alert alert-info'>No se encontraron clientes en el rango de fechas seleccionado.</div>";
                                    }
                                    } else {
                                        // Si no hay filtros, mostrar un mensaje indicando que debe seleccionar fechas
                                        echo "<div class='alert alert-info'>Seleccione un rango de fechas para ver los resultados.</div>";
                                    }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    // Función para inicializar DataTable
    function initDataTable() {
        if ($.fn.DataTable.isDataTable('#reportestable')) {
            $('#reportestable').DataTable().destroy();
        }

        $('#reportestable').DataTable({
            language: {
                processing: "Procesando...",
                search: "Buscar:",
                lengthMenu: "Mostrar _MENU_ elementos",
                info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                infoEmpty: "Mostrando ningún elemento.",
                infoFiltered: "(filtrado _MAX_ elementos total)",
                infoPostFix: "",
                loadingRecords: "Cargando registros...",
                zeroRecords: "No se encontraron registros",
                emptyTable: "No hay datos disponibles en la tabla",
                paginate: {
                    first: "Primero",
                    previous: "Anterior",
                    next: "Siguiente",
                    last: "Último"
                },
                aria: {
                    sortAscending: ": Activar para ordenar la columna de manera ascendente",
                    sortDescending: ": Activar para ordenar la columna de manera descendente"
                },
                buttons: {
                    copyTitle: 'Copiado al portapapeles',
                    copySuccess: {
                        _: '%d filas copiadas',
                        1: '1 fila copiada'
                    }
                }
            },
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'copyHtml5',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csvHtml5',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excelHtml5',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdfHtml5',
                    exportOptions: {
                        columns: ':visible'
                    },
                    customize: function (doc) {
                        // Cambiar la fuente del PDF a Arial
                        doc.defaultStyle.font = 'Arial';
                    }
                },
                {
                    extend: 'print',
                    exportOptions: {
                        columns: ':visible'
                    }
                }
            ]
        });
    }

    // Función para actualizar el botón PDF
    function actualizarBotonPDF(esTodos = false) {
        // Limpiar el contenedor del botón PDF
        $('#contenedor-btn-pdf').empty();
        
        // Agregar el botón apropiado si hay datos en la tabla
        if ($('#reportestable').length > 0) {
            var textoBoton = esTodos ? 'Generar PDF (Todos)' : 'Generar PDF (Filtrados)';
            var idBoton = esTodos ? 'generarPdfTodos' : 'generarPdf';
            
            $('#contenedor-btn-pdf').html(
                '<button type="button" id="' + idBoton + '" class="btn btn-danger mt-2">' + textoBoton + '</button>'
            );
        }
    }

    // Inicializar DataTable si existe la tabla
    if ($('#reportestable').length) {
        initDataTable();
    }

    // Manejar clic en el botón para mostrar todos los clientes
    $('#reporteCompleto').on('click', function(e) {
        e.preventDefault();
        
        // Limpiar los inputs de fecha
        $('#desde').val('');
        $('#hasta').val('');
        
        // Mostrar indicador de carga
        $('#tabla-contenedor').html('<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Cargando...</span></div></div>');
        
        // Limpiar botones PDF mientras carga
        $('#contenedor-btn-pdf').empty();
        
        // Realizar solicitud AJAX para obtener todos los clientes
        $.ajax({
            url: 'index.php?action=obtener_todos_clientes&mostrar_todo=1',
            type: 'GET',
            dataType: 'html',
            success: function(response) {
                $('#tabla-contenedor').html(response);
                
                // Reinicializar DataTable
                if ($('#reportestable').length) {
                    initDataTable();
                    // Actualizar botón PDF para mostrar "Todos"
                    actualizarBotonPDF(true);
                }
            },
            error: function() {
                $('#tabla-contenedor').html('<div class="alert alert-danger">Error al cargar los datos. Por favor, inténtelo de nuevo.</div>');
            }
        });
    });

    // Manejar clic en el botón para generar PDF (filtrados)
    $(document).on('click', '#generarPdf', function(e) {
        e.preventDefault();
        
        // Obtener las fechas del formulario
        var desde = $('#desde').val();
        var hasta = $('#hasta').val();
        
        // Validar que las fechas estén presentes
        if (!desde || !hasta) {
            alert('Por favor, seleccione un rango de fechas válido.');
            return;
        }
        
        // Abrir nueva ventana/pestaña con el PDF
        window.open('index.php?action=generar_pdf_clientes&desde=' + desde + '&hasta=' + hasta, '_blank');
    });

    // Manejar clic en el botón para generar PDF (todos)
    $(document).on('click', '#generarPdfTodos', function(e) {
        e.preventDefault();
        window.open('index.php?action=generar_pdf_clientes&mostrar_todo=1', '_blank');
    });
});
</script>