<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card shadow-lg rounded-3 border-0">
                        <div class="card-header bg-primary bg-gradient text-white py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0 text-white fw-bold">
                                    <i class="fas fa-exchange-alt me-2"></i> Reporte de Ventas
                                </h4>
                                <!-- <div>
                                    <button class="btn btn-light btn-sm rounded-pill shadow-sm me-2">
                                        <i class="fas fa-download me-1"></i> Exportar
                                    </button>
                                    <button class="btn btn-outline-light btn-sm rounded-pill shadow-sm">
                                        <i class="fas fa-print me-1"></i> Imprimir
                                    </button>
                                </div> -->
                            </div>
                        </div>
                        <div class="card-body p-4">
                            <div class="row g-3 mb-4">
                                <div class="col-md-2">
                                    <label for="start" class="form-label fw-bold text-primary">
                                        <i class="far fa-calendar-alt me-2"></i>Fecha Inicio
                                    </label>
                                    <input type="date" name="start" id="start" class="form-control form-control-sm shadow-sm rounded-pill">
                                </div>
                                <div class="col-md-2">
                                    <label for="end" class="form-label fw-bold text-primary">
                                        <i class="far fa-calendar-alt me-2"></i>Fecha Final
                                    </label>
                                    <input type="date" name="end" id="end" class="form-control form-control-sm shadow-sm rounded-pill">
                                </div>
                                <div class="col-md-3">
                                    <label for="usuario" class="form-label fw-bold text-primary">
                                        <i class="fas fa-random me-2"></i>Trabajador
                                    </label>
                                    <select name="usuario" id="usuario" class="form-select form-select-sm shadow-sm rounded-pill">
                                        <option selected disabled>Seleccionar...</option>
                                        <option value="">Todo</option>
                                        <?php $users = UserData::vercontenido();
                                        foreach ($users as $user) { ?>
                                        <option value="<?= $user->id; ?>"><?= $user->nombre." ".$user->apellido; ?></option>     
                                       <?php  } ?>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <div class="d-flex w-100">
                                        <button id="btn-filtrar" class="btn btn-primary btn-sm rounded-pill shadow-sm flex-grow-1 me-2">
                                            <i class="fas fa-filter me-1"></i> Filtrar
                                        </button>
                                        <button id="btn-limpiar" class="btn btn-outline-danger btn-sm rounded-pill shadow-sm">
                                            <i class="fas fa-broom me-1"></i> Limpiar
                                        </button>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="alert alert-info rounded-3 shadow-sm mb-4">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-info-circle fs-4 me-3"></i>
                                    <div>
                                        <h5 class="alert-heading mb-1">Instrucciones</h5>
                                        <p class="mb-0 small">Seleccione los filtros y haga clic en "Filtrar" para generar el reporte de Ventas.</p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="table-responsive">
                                <table id="customerTable1" class="table table-bordered  table-striped align-middle" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Articulo</th>
                                            <th>Unidad</th>
                                            <th>Cantidad</th>
                                            <th>Precio</th>
                                            <th>Subtotal</th>
                                            <th>Número Facfoli</th>
                                            <th>Cliente</th>
                                        </tr>
                                    </thead>
                                    <tbody id="resultados-body" class="small">
                                        
                                    </tbody>
                                    <tfoot>
                                      <tr>
                                        <th colspan="3" style="text-align:right">Totales:</th>
                                        <th></th> <!-- cantidad -->
                                        <th></th> <!-- precio -->
                                        <th></th> <!-- subtotal -->
                                        <th colspan="2"></th>
                                      </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function () {
    try {
        // Configuración de fuentes para pdfmake
        pdfMake.fonts = {
            Roboto: {
                normal: 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/fonts/Roboto/Roboto-Regular.ttf',
                bold: 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/fonts/Roboto/Roboto-Medium.ttf',
                italics: 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/fonts/Roboto/Roboto-Italic.ttf',
                bolditalics: 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.66/fonts/Roboto/Roboto-MediumItalic.ttf'
            }
        };

        if ($.fn.DataTable.isDataTable('#customerTable1')) {
            $('#customerTable1').DataTable().destroy();
        }

        const tabla = $('#customerTable1').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            language: {
                "sProcessing": "Procesando...",
                "sZeroRecords": "No se encontraron resultados",
                "sEmptyTable": "Ningún dato disponible en esta tabla",
                "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                "sSearch": "Buscar:",
                "sLoadingRecords": "Cargando...",
            },
            footerCallback: function (row, data, start, end, display) {
                const api = this.api();

                const intVal = i => typeof i === 'string' ?
                    parseFloat(i.replace(/[^\d.-]/g, '')) || 0 :
                    (typeof i === 'number' ? i : 0);

                // Calcular total de cantidad (columna 3)
                const totalCantidad = api.column(3).data().reduce((a, b) => a + intVal(b), 0);
                
                // Calcular total de precio (columna 4)
                const totalPrecio = api.column(4).data().reduce((a, b) => {
                    const valor = typeof b === 'string' ? 
                        parseFloat(b.replace(/[^\d.-]/g, '')) : 
                        parseFloat(b);
                    return a + (isNaN(valor) ? 0 : valor);
                }, 0);

                // Calcular total general (multiplicando cantidad * precio de cada fila)
                const totalGeneral = data.reduce((total, row) => {
                    const cantidad = intVal(row.cantidad);
                    const precio = typeof row.precio === 'string' ? 
                        parseFloat(row.precio.replace(/[^\d.-]/g, '')) : 
                        parseFloat(row.precio);
                    return total + (cantidad * (isNaN(precio) ? 0 : precio));
                }, 0);

                // Actualizar los totales en el pie de tabla
                $(api.column(3).footer()).html(
                    new Intl.NumberFormat('es-CO', { 
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0 
                    }).format(totalCantidad)
                );
                
                $(api.column(4).footer()).html(
                    new Intl.NumberFormat('es-CO', { 
                        style: 'currency', 
                        currency: 'COP',
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    }).format(totalPrecio)
                );
                
                $(api.column(5).footer()).html(
                    new Intl.NumberFormat('es-CO', { 
                        style: 'currency', 
                        currency: 'COP',
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    }).format(totalGeneral)
                );
            },
            data: [],
            columns: [
                { data: 'fecha' },
                { data: 'articulo' },
                { data: 'unidad' },
                { 
                    data: 'cantidad',
                    render: data => new Intl.NumberFormat('es-CO', {
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    }).format(data)
                },
                { 
                    data: 'precio',
                    render: data => new Intl.NumberFormat('es-CO', {
                        style: 'currency', 
                        currency: 'COP',
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    }).format(data)
                },
                {
                    data: null,
                    render: data => {
                        const cantidad = parseFloat(data.cantidad) || 0;
                        const precio = typeof data.precio === 'string' ? 
                            parseFloat(data.precio.replace(/[^\d.-]/g, '')) : 
                            parseFloat(data.precio) || 0;
                        const total = cantidad * precio;
                        return new Intl.NumberFormat('es-CO', {
                            style: 'currency', 
                            currency: 'COP',
                            minimumFractionDigits: 0,
                            maximumFractionDigits: 0
                        }).format(total);
                    }
                },
                { data: 'numerofacfoli' },
                { data: 'cliente' }
            ],
            buttons: [
                {
                    extend: 'excelHtml5',
                    title: 'REPORTE DE TRANSFERENCIA - SIS VENTAS',
                    footer: true
                },
                {
                    extend: 'csvHtml5',
                    title: 'REPORTE DE TRANSFERENCIA - SIS VENTAS',
                    footer: true
                },
                {
                    extend: 'pdfHtml5',
                    title: 'REPORTE DE TRANSFERENCIA - SIS VENTAS',
                    orientation: 'landscape',
                    pageSize: 'A4',
                    footer: true,
                    customize: function (doc) {
                        // Configuración de estilos
                        doc.defaultStyle = {
                            font: 'Roboto',
                            fontSize: 10
                        };

                        // Logo
                        doc.content.splice(0, 0, {
                            margin: [0, 0, 0, 12],
                            alignment: 'center',
                            image: 'data:image/png;base64,<?= base64_encode(file_get_contents("storage/per/logo.png")) ?>',
                            width: 50
                        });

                        // Título
                        doc.content[1].text = 'REPORTE DE TRANSFERENCIA - SIS VENTAS';
                        doc.content[1].alignment = 'center';
                        doc.content[1].margin = [0, 0, 0, 10];
                        doc.content[1].fontSize = 14;
                        doc.content[1].bold = true;

                        // Estilo de la tabla
                        doc.content[2].table.widths = ['auto', '*', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto'];
                        
                        // Estilo del encabezado de la tabla
                        doc.content[2].table.body[0].forEach(function(cell) {
                            cell.fillColor = '#2c3e50';
                            cell.color = '#ffffff';
                            cell.fontSize = 10;
                            cell.bold = true;
                        });

                        // Cálculo de totales
                        const totalCantidad = tabla.column(3, { page: 'all' }).data()
                            .reduce((a, b) => a + (parseFloat(b) || 0), 0);

                        const totalPrecio = tabla.column(4, { page: 'all' }).data()
                            .reduce((a, b) => a + (typeof b === 'number' ? b : parseFloat(b.toString().replace(/[^\d.-]/g, '')) || 0), 0);

                        const totalGeneral = tabla.rows({ page: 'all' }).data()
                            .reduce((acc, row) => acc + ((parseFloat(row.cantidad) || 0) * (parseFloat(row.precio) || 0)), 0);

                        // Agregar totales al final
                        doc.content.push({
                            margin: [0, 20, 0, 0],
                            table: {
                                widths: ['*', '*', '*'],
                                body: [
                                    [
                                        { text: 'Total Cantidad', style: 'tableHeader', alignment: 'right' },
                                        { text: 'Total Precio', style: 'tableHeader', alignment: 'right' },
                                        { text: 'Total General', style: 'tableHeader', alignment: 'right' }
                                    ],
                                    [
                                        { 
                                            text: new Intl.NumberFormat('es-CO', { 
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0 
                                            }).format(totalCantidad),
                                            alignment: 'right'
                                        },
                                        { 
                                            text: new Intl.NumberFormat('es-CO', { 
                                                style: 'currency', 
                                                currency: 'COP',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(totalPrecio),
                                            alignment: 'right'
                                        },
                                        { 
                                            text: new Intl.NumberFormat('es-CO', { 
                                                style: 'currency', 
                                                currency: 'COP',
                                                minimumFractionDigits: 0,
                                                maximumFractionDigits: 0
                                            }).format(totalGeneral),
                                            alignment: 'right'
                                        }
                                    ]
                                ]
                            },
                            layout: 'lightHorizontalLines'
                        });
                    }
                }
            ]
        });

        $('#btn-filtrar').on('click', function () {
            const start = $('#start').val();
            const end = $('#end').val();
            const usuario = $('#usuario').val();

            $.ajax({
                url: 'index.php?action=reporte&actions=3',
                type: 'POST',
                data: {
                    usuario: usuario,
                    start: start,
                    end: end
                },
                dataType: 'json',
                success: function (data) {
                    tabla.clear().rows.add(data).draw();
                },
                error: function (xhr, status, error) {
                    console.error(error);
                    alert('Ocurrió un error al cargar los datos');
                }
            });
        });

        $('#btn-limpiar').on('click', function () {
            $('#start').val('');
            $('#end').val('');
            $('#usuario').val('');
            tabla.clear().draw();
        });
    } catch (error) {
        console.error('Error al inicializar DataTables:', error);
    }
});
</script>