<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <!-- Espacio para un título si lo requieres -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
<?php
// Conectar a la base de datos
$base = Database::getInstance();
$conn = $base->getConnection();

// Consulta para obtener los datos de salida de productos
$query = "
    SELECT p.articulo, p.fecha, p.cantidad, p.precio AS precio_venta, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color,
           (SELECT AVG(pc.precio) FROM proceso pc WHERE pc.articulo = p.articulo AND pc.accion = 1) AS precio_promedio_compra,
           (SELECT AVG(pv.precio) FROM proceso pv WHERE pv.articulo = p.articulo AND pv.accion = 2) AS precio_promedio_venta
    FROM proceso p
    JOIN articulo a ON p.articulo = a.id
    WHERE p.accion = 2
";
$result = $conn->query($query);

$salesData = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $salesData[] = [
            'articulo' => $row['articulo'],
            'fecha' => $row['fecha'],
            'cantidad' => $row['cantidad'],
            'precio_venta' => $row['precio_venta'],
            'precio_promedio_compra' => $row['precio_promedio_compra'],
            'precio_promedio_venta' => $row['precio_promedio_venta'],
            'nombre' => $row['nombre'],
            'categoria' => $row['categoria'],
            'marca' => $row['marca'],
            'serie' => $row['serie'],
            'modelo' => $row['modelo'],
            'estado' => $row['estado'],
            'color' => $row['color']
        ];
    }
} else {
    echo "No data found";
}

$conn->close();
?>

<script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
<script>
// Datos extraídos de la base de datos (por simplicidad, aquí se muestran como ejemplo)
const salesData = <?php echo json_encode($salesData); ?>;

// Convertir las fechas a índices y normalizar las cantidades
const dates = salesData.map(data => new Date(data.fecha));
const quantities = salesData.map(data => data.cantidad);

const startDate = new Date(Math.min(...dates));
const normalizedDates = dates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24))); // Convertir a días enteros

const maxQuantity = Math.max(...quantities);
const normalizedQuantities = quantities.map(qty => qty / maxQuantity);

// Agregar características adicionales
const months = dates.map(date => date.getMonth() + 1); // Mes del año
const dayOfWeek = dates.map(date => date.getDay()); // Día de la semana
const priceVentas = salesData.map(data => data.precio_venta);
const avgCompra = salesData.map(data => data.precio_promedio_compra);
const avgVenta = salesData.map(data => data.precio_promedio_venta);
const article = salesData.map(data => data.articulo); // Corregido de 'article' a 'articulo'

const maxMonth = Math.max(...months);
const normalizedMonths = months.map(month => month / maxMonth);

const maxDayOfWeek = Math.max(...dayOfWeek);
const normalizedDayOfWeek = dayOfWeek.map(day => day / maxDayOfWeek);

const maxPriceVenta = Math.max(...priceVentas);
const normalizedPriceVentas = priceVentas.map(price => price / maxPriceVenta);

const maxAvgCompra = Math.max(...avgCompra);
const normalizedAvgCompra = avgCompra.map(price => price / maxAvgCompra);

// Crear el dataset para TensorFlow.js
const xs = tf.tensor2d(normalizedDates.map((date, i) => [date, normalizedMonths[i], normalizedDayOfWeek[i], normalizedPriceVentas[i], normalizedAvgCompra[i]]));
const ys = tf.tensor2d(normalizedQuantities, [normalizedQuantities.length, 1]);

// Dividir los datos en conjuntos de entrenamiento y prueba
const splitIndex = Math.floor(xs.shape[0] * 0.8);
const xsTrain = xs.slice([0, 0], [splitIndex, 5]);
const ysTrain = ys.slice([0, 0], [splitIndex, 1]);
const xsTest = xs.slice([splitIndex, 0], [xs.shape[0] - splitIndex, 5]);
const ysTest = ys.slice([splitIndex, 0], [ys.shape[0] - splitIndex, 1]);

// Crear el modelo
const model = tf.sequential();
model.add(tf.layers.dense({ units: 64, activation: 'relu', inputShape: [5], kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
model.add(tf.layers.dense({ units: 64, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
model.add(tf.layers.dense({ units: 32, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
model.add(tf.layers.dense({ units: 1 }));

model.compile({
  optimizer: tf.train.adam(0.0005), // Ajustar la tasa de aprendizaje
  loss: 'meanSquaredError'
});

// Callback para detener el entrenamiento si no hay mejora
const earlyStoppingCallback = tf.callbacks.earlyStopping({
  monitor: 'val_loss',
  patience: 15
});

// Entrenar el modelo
model.fit(xsTrain, ysTrain, {
  epochs: 300, // Aumentar el número de épocas
  validationData: [xsTest, ysTest],
  callbacks: [earlyStoppingCallback],
  onEpochEnd: (epoch, logs) => {
    console.log(`Epoch ${epoch}: loss = ${logs.loss}`);
  }
}).then(() => {
  // Obtener la última fecha en el conjunto de datos
  const lastDate = new Date(Math.max(...dates));
  const futureDaysCount = 3; // Número de días futuros a predecir
  const futureDates = Array.from({ length: futureDaysCount }, (_, i) => {
    const futureDate = new Date(lastDate);
    futureDate.setDate(futureDate.getDate() + (i + 1) * 30); // Ejemplo: predicciones para cada mes (30 días)
    return futureDate;
  });

  const futureDays = futureDates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24)));
  const futureMonths = futureDates.map(date => (date.getMonth() + 1) / maxMonth);
  const futureDayOfWeek = futureDates.map(date => date.getDay() / maxDayOfWeek);
  const futurePriceVenta = futureDates.map(date => salesData[0].precio_venta / maxPriceVenta);
  const futureAvgCompra = futureDates.map(date => salesData[0].precio_promedio_compra / maxAvgCompra);

  const futureData = futureDays.map((day, i) => [day, futureMonths[i], futureDayOfWeek[i], futurePriceVenta[i], futureAvgCompra[i]]);
  const futureDatesTensor = tf.tensor2d(futureData);

  const predictions = model.predict(futureDatesTensor);
  predictions.print(); // Mostrar las predicciones en la consola

  predictions.array().then(array => {
    array.forEach((pred, index) => {
      const predictedQuantity = Math.round(pred[0] * maxQuantity); // Redondear a enteros
      const futureDate = futureDates[index];

      // Calcular la ganancia y determinar la rentabilidad
      const precioPromedioCompra = salesData[0].precio_promedio_compra; // Suponiendo que todos los productos tienen el mismo precio de compra
      const precioPromedioVenta = salesData[0].precio_venta; // Suponiendo que todos los productos tienen el mismo precio de venta
      const ganancia = predictedQuantity * Math.round(salesData[0].precio_promedio_venta);
      const rentable = ganancia > 500 ? 'Rentable' : 'No rentable';

      console.log(`Producto: ${(salesData[0].articulo)}:`); // Corregido de 'article' a 'articulo'
      console.log(`Prediction for ${futureDate.toDateString()}:`);
      console.log(`Cantidad: ${predictedQuantity}`);
      console.log(`Ganancia: ${ganancia.toFixed(2)}`);
      console.log(`Rentabilidad: ${rentable}`);
      console.log(`Precio Promedio Venta: ${Math.round(salesData[0].precio_promedio_venta)}`);
    });
  });
});
</script>





                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 






























<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <!-- Espacio para un título si lo requieres -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
<?php
// Conectar a la base de datos
$base = Database::getInstance();
$conn = $base->getConnection();

// Consulta para obtener los datos de salida de productos
$query = "
    SELECT p.articulo, p.fecha, p.cantidad, p.precio AS precio_venta, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color,
           (SELECT AVG(pc.precio) FROM proceso pc WHERE pc.articulo = p.articulo AND pc.accion = 1) AS precio_promedio_compra,
           (SELECT AVG(pv.precio) FROM proceso pv WHERE pv.articulo = p.articulo AND pv.accion = 2) AS precio_promedio_venta
    FROM proceso p
    JOIN articulo a ON p.articulo = a.id
    WHERE p.accion = 2
";
$result = $conn->query($query);

$salesData = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $salesData[] = [
            'articulo' => $row['articulo'],
            'fecha' => $row['fecha'],
            'cantidad' => $row['cantidad'],
            'precio_venta' => $row['precio_venta'],
            'precio_promedio_compra' => $row['precio_promedio_compra'],
            'precio_promedio_venta' => $row['precio_promedio_venta'],
            'nombre' => $row['nombre'],
            'categoria' => $row['categoria'],
            'marca' => $row['marca'],
            'serie' => $row['serie'],
            'modelo' => $row['modelo'],
            'estado' => $row['estado'],
            'color' => $row['color']
        ];
    }
} else {
    echo "No data found";
}

$conn->close();
?>

<script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div id="chartsContainer"></div>

<script>
// Datos extraídos de la base de datos (por simplicidad, aquí se muestran como ejemplo)
const salesData = <?php echo json_encode($salesData); ?>;

// Crear una función para entrenar el modelo y generar predicciones
async function trainAndPredictForArticle(articleData) {
  const dates = articleData.map(data => new Date(data.fecha));
  const quantities = articleData.map(data => data.cantidad);

  const startDate = new Date(Math.min(...dates));
  const normalizedDates = dates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24))); // Convertir a días enteros

  const maxQuantity = Math.max(...quantities);
  const normalizedQuantities = quantities.map(qty => qty / maxQuantity);

  // Agregar características adicionales
  const months = dates.map(date => date.getMonth() + 1); // Mes del año
  const dayOfWeek = dates.map(date => date.getDay()); // Día de la semana
  const priceVentas = articleData.map(data => data.precio_venta);
  const avgCompra = articleData.map(data => data.precio_promedio_compra);
  const avgVenta = articleData.map(data => data.precio_promedio_venta);

  const maxMonth = Math.max(...months);
  const normalizedMonths = months.map(month => month / maxMonth);

  const maxDayOfWeek = Math.max(...dayOfWeek);
  const normalizedDayOfWeek = dayOfWeek.map(day => day / maxDayOfWeek);

  const maxPriceVenta = Math.max(...priceVentas);
  const normalizedPriceVentas = priceVentas.map(price => price / maxPriceVenta);

  const maxAvgCompra = Math.max(...avgCompra);
  const normalizedAvgCompra = avgCompra.map(price => price / maxAvgCompra);

  // Crear el dataset para TensorFlow.js
  const xs = tf.tensor2d(normalizedDates.map((date, i) => [date, normalizedMonths[i], normalizedDayOfWeek[i], normalizedPriceVentas[i], normalizedAvgCompra[i]]));
  const ys = tf.tensor2d(normalizedQuantities, [normalizedQuantities.length, 1]);

  // Dividir los datos en conjuntos de entrenamiento y prueba
  const splitIndex = Math.floor(xs.shape[0] * 0.8);
  const xsTrain = xs.slice([0, 0], [splitIndex, 5]);
  const ysTrain = ys.slice([0, 0], [splitIndex, 1]);
  const xsTest = xs.slice([splitIndex, 0], [xs.shape[0] - splitIndex, 5]);
  const ysTest = ys.slice([splitIndex, 0], [ys.shape[0] - splitIndex, 1]);

  // Crear el modelo
  const model = tf.sequential();
  model.add(tf.layers.dense({ units: 64, activation: 'relu', inputShape: [5], kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 64, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 32, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 1 }));

  model.compile({
    optimizer: tf.train.adam(0.0005), // Ajustar la tasa de aprendizaje
    loss: 'meanSquaredError'
  });

  // Callback para detener el entrenamiento si no hay mejora
  const earlyStoppingCallback = tf.callbacks.earlyStopping({
    monitor: 'val_loss',
    patience: 15
  });

  // Entrenar el modelo
  await model.fit(xsTrain, ysTrain, {
    epochs: 300, // Aumentar el número de épocas
    validationData: [xsTest, ysTest],
    callbacks: [earlyStoppingCallback],
    onEpochEnd: (epoch, logs) => {
      console.log(`Epoch ${epoch}: loss = ${logs.loss}`);
    }
  });

  // Obtener la última fecha en el conjunto de datos
  const lastDate = new Date(Math.max(...dates));
  const futureDaysCount = 6; // Número de días futuros a predecir
  const futureDates = Array.from({ length: futureDaysCount }, (_, i) => {
    const futureDate = new Date(lastDate);
    // futureDate.setMonth(futureDate.getMonth() + (i + 1) * 30); // Ejemplo: predicciones para cada mes (30 días)
    futureDate.setDate(futureDate.getDate() + (i + 1) * 30); // para días
    return futureDate;
  });

  const futureDays = futureDates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24)));
  const futureMonths = futureDates.map(date => (date.getMonth() + 1) / maxMonth);
  const futureDayOfWeek = futureDates.map(date => date.getDay() / maxDayOfWeek);
  const futurePriceVenta = futureDates.map(date => articleData[0].precio_venta / maxPriceVenta);
  const futureAvgCompra = futureDates.map(date => articleData[0].precio_promedio_compra / maxAvgCompra);

  const futureData = futureDays.map((day, i) => [day, futureMonths[i], futureDayOfWeek[i], futurePriceVenta[i], futureAvgCompra[i]]);
  const futureDatesTensor = tf.tensor2d(futureData);

  const predictions = model.predict(futureDatesTensor);

  const predictedQuantities = await predictions.array();
  const labels = futureDates.map(date => date.toDateString());

  // Crear el gráfico para este artículo
  const chartContainer = document.getElementById('chartsContainer');
  const canvas = document.createElement('canvas');
  canvas.id = `chart-${articleData[0].articulo}`;
  chartContainer.appendChild(canvas);
  const ctx = canvas.getContext('2d');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        // label: `Cantidad Predicha (${articleData[0].nombre})`,
        label: `(${articleData[0].nombre})`,
        data: predictedQuantities.map(pred => Math.round(pred[0] * maxQuantity)),
        borderColor: 'rgba(75, 192, 192, 1)',
        borderWidth: 1,
        fill: false
      }]
    },
    options: {
      scales: {
        y: {
          beginAtZero: true
        }
      }
    }
  });

  predictedQuantities.forEach((pred, index) => {
    const predictedQuantity = Math.round(pred[0] * maxQuantity); // Redondear a enteros
    const futureDate = futureDates[index];

    // Calcular la ganancia y determinar la rentabilidad
    const precioPromedioCompra = articleData[0].precio_promedio_compra; // Suponiendo que todos los productos tienen el mismo precio de compra
    const precioPromedioVenta = articleData[0].precio_venta; // Suponiendo que todos los productos tienen el mismo precio de venta
    const ganancia = predictedQuantity * Math.round(articleData[0].precio_promedio_venta);
    const rentable = ganancia > 500 ? 'Rentable' : 'No rentable';

    console.log(`Producto: ${(articleData[0].articulo)}:`);
    console.log(`Prediction for ${futureDate.toDateString()}:`);
    console.log(`Cantidad: ${predictedQuantity}`);
    console.log(`Ganancia: ${ganancia.toFixed(2)}`);
    console.log(`Rentabilidad: ${rentable}`);
    console.log(`Precio Promedio Venta: ${Math.round(articleData[0].precio_promedio_venta)}`);
  });
}

// Llamar a la función para cada artículo en salesData
const articles = salesData.reduce((acc, item) => {
  (acc[item.articulo] = acc[item.articulo] || []).push(item);
  return acc;
}, {});

for (const article in articles) {
  trainAndPredictForArticle(articles[article]);
}
</script>



                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 









































<?php
// Conectar a la base de datos
$base = Database::getInstance();
$conn = $base->getConnection();

// Consulta para obtener los datos de salida de productos
$query = "
    SELECT p.articulo, p.fecha, p.cantidad, p.precio AS precio_venta, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color,
           (SELECT AVG(pc.precio) FROM proceso pc WHERE pc.articulo = p.articulo AND pc.accion = 1) AS precio_promedio_compra,
           (SELECT AVG(pv.precio) FROM proceso pv WHERE pv.articulo = p.articulo AND pv.accion = 2) AS precio_promedio_venta
    FROM proceso p
    JOIN articulo a ON p.articulo = a.id
    WHERE p.accion = 2
";
$result = $conn->query($query);

$salesData = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $salesData[] = [
            'articulo' => $row['articulo'],
            'fecha' => $row['fecha'],
            'cantidad' => $row['cantidad'],
            'precio_venta' => $row['precio_venta'],
            'precio_promedio_compra' => $row['precio_promedio_compra'],
            'precio_promedio_venta' => $row['precio_promedio_venta'],
            'nombre' => $row['nombre'],
            'categoria' => $row['categoria'],
            'marca' => $row['marca'],
            'serie' => $row['serie'],
            'modelo' => $row['modelo'],
            'estado' => $row['estado'],
            'color' => $row['color']
        ];
    }
} else {
    echo "No data found";
}

$conn->close();
?>

<script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div id="chartsContainer"></div>

<script>
// Datos extraídos de la base de datos (por simplicidad, aquí se muestran como ejemplo)
const salesData = <?php echo json_encode($salesData); ?>;

// Crear una función para entrenar el modelo y generar predicciones
async function trainAndPredictForArticle(articleData) {
  const dates = articleData.map(data => new Date(data.fecha));
  const quantities = articleData.map(data => data.cantidad);

  const startDate = new Date(Math.min(...dates));
  const normalizedDates = dates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24))); // Convertir a días enteros

  const maxQuantity = Math.max(...quantities);
  const normalizedQuantities = quantities.map(qty => qty / maxQuantity);

  // Agregar características adicionales
  const months = dates.map(date => date.getMonth() + 1); // Mes del año
  const year = dates.map(date => date.getFullYear()); // Año
  const priceVentas = articleData.map(data => data.precio_venta);
  const avgCompra = articleData.map(data => data.precio_promedio_compra);
  const avgVenta = articleData.map(data => data.precio_promedio_venta);

  const maxMonth = Math.max(...months);
  const normalizedMonths = months.map(month => month / maxMonth);

  const uniqueYears = [...new Set(year)]; // Obtener los años únicos

  // Crear el dataset para TensorFlow.js
  const xs = tf.tensor2d(normalizedDates.map((date, i) => [date, normalizedMonths[i]]));
  const ys = tf.tensor2d(normalizedQuantities, [normalizedQuantities.length, 1]);

  // Dividir los datos en conjuntos de entrenamiento y prueba
  const splitIndex = Math.floor(xs.shape[0] * 0.8);
  const xsTrain = xs.slice([0, 0], [splitIndex, 2]);
  const ysTrain = ys.slice([0, 0], [splitIndex, 1]);
  const xsTest = xs.slice([splitIndex, 0], [xs.shape[0] - splitIndex, 2]);
  const ysTest = ys.slice([splitIndex, 0], [ys.shape[0] - splitIndex, 1]);

  // Crear el modelo
  const model = tf.sequential();
  model.add(tf.layers.dense({ units: 64, activation: 'relu', inputShape: [2], kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 64, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 32, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 1 }));

  model.compile({
    optimizer: tf.train.adam(0.0005), // Ajustar la tasa de aprendizaje
    loss: 'meanSquaredError'
  });

  // Callback para detener el entrenamiento si no hay mejora
  const earlyStoppingCallback = tf.callbacks.earlyStopping({
    monitor: 'val_loss',
    patience: 15
  });

  // Entrenar el modelo
  await model.fit(xsTrain, ysTrain, {
    epochs: 300, // Aumentar el número de épocas
    validationData: [xsTest, ysTest],
    callbacks: [earlyStoppingCallback],
    onEpochEnd: (epoch, logs) => {
      console.log(`Epoch ${epoch}: loss = ${logs.loss}`);
    }
  });

  // Obtener la última fecha en el conjunto de datos
  const lastDate = new Date(Math.max(...dates));
  const futureDaysCount = 3; // Número de días futuros a predecir
  const futureDates = Array.from({ length: futureDaysCount }, (_, i) => {
    const futureDate = new Date(lastDate);
    futureDate.setMonth(futureDate.getMonth() + (i + 1)); // Ejemplo: predicciones para cada mes
    return futureDate;
  });

  const futureMonths = futureDates.map(date => (date.getMonth() + 1) / maxMonth);
  const futureYear = futureDates.map(date => date.getFullYear()); // Año de las fechas futuras

  const futureData = futureMonths.map((month, i) => [futureMonths[i], futureYear[i]]);
  const futureDatesTensor = tf.tensor2d(futureData);

  const predictions = model.predict(futureDatesTensor);

  const predictedQuantities = await predictions.array();
  const labels = futureDates.map(date => `${date.toLocaleString('default', { month: 'long' })} ${date.getFullYear()}`);

  // Crear el gráfico para este artículo
  const chartContainer = document.getElementById('chartsContainer');
  const canvas = document.createElement('canvas');
  canvas.id = `chart-${articleData[0].articulo}`;
  chartContainer.appendChild(canvas);
  const ctx = canvas.getContext('2d');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        label: `Cantidad Predicha (${articleData[0].articulo})`,
        data: predictedQuantities.map(pred => Math.round(pred[0] * maxQuantity)),
        borderColor: 'rgba(75, 192, 192, 1)',
        borderWidth: 1,
        fill: false
      }]
    },
    options: {
      scales: {
        y: {
          beginAtZero: true
        }
      }
    }
  });

  predictedQuantities.forEach((pred, index) => {
    const predictedQuantity = Math.round(pred[0] * maxQuantity); // Redondear a enteros
    const futureDate = futureDates[index];

    // Calcular la ganancia y determinar la rentabilidad
    const precioPromedioCompra = articleData[0].precio_promedio_compra; // Suponiendo que todos los productos tienen el mismo precio de compra
    const precioPromedioVenta = articleData[0].precio_venta; // Suponiendo que todos los productos tienen el mismo precio de venta
    const ganancia = predictedQuantity * Math.round(articleData[0].precio_promedio_venta);
    const rentable = ganancia > 500 ? 'Rentable' : 'No rentable';

    console.log(`Producto: ${(articleData[0].articulo)}:`);
    console.log(`Prediction for ${futureDate.toLocaleString('default', { month: 'long', year: 'numeric' })}:`);
    console.log(`Cantidad: ${predictedQuantity}`);
    console.log(`Ganancia: ${ganancia.toFixed(2)}`);
    console.log(`Rentabilidad: ${rentable}`);
    console.log(`Precio Promedio Venta: ${Math.round(articleData[0].precio_promedio_venta)}`);
  });
}

// Llamar a la función para cada artículo en salesData
const articles = salesData.reduce((acc, item) => {
  (acc[item.articulo] = acc[item.articulo] || []).push(item);
  return acc;
}, {});

for (const article in articles) {
  trainAndPredictForArticle(articles[article]);
}
</script>































<?php
// Conectar a la base de datos
$base = Database::getInstance();
$conn = $base->getConnection();

// Consulta para obtener los datos de salida de productos
$query = "
    SELECT p.articulo, p.fecha, p.cantidad, p.precio AS precio_venta, a.nombre, a.categoria, a.marca, a.serie, a.modelo, a.estado, a.color,
           (SELECT AVG(pc.precio) FROM proceso pc WHERE pc.articulo = p.articulo AND pc.accion = 1) AS precio_promedio_compra,
           (SELECT AVG(pv.precio) FROM proceso pv WHERE pv.articulo = p.articulo AND pv.accion = 2) AS precio_promedio_venta
    FROM proceso p
    JOIN articulo a ON p.articulo = a.id
    WHERE p.accion = 2
";
$result = $conn->query($query);

$salesData = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $salesData[] = [
            'articulo' => $row['articulo'],
            'fecha' => $row['fecha'],
            'cantidad' => $row['cantidad'],
            'precio_venta' => $row['precio_venta'],
            'precio_promedio_compra' => $row['precio_promedio_compra'],
            'precio_promedio_venta' => $row['precio_promedio_venta'],
            'nombre' => $row['nombre'],
            'categoria' => $row['categoria'],
            'marca' => $row['marca'],
            'serie' => $row['serie'],
            'modelo' => $row['modelo'],
            'estado' => $row['estado'],
            'color' => $row['color']
        ];
    }
} else {
    echo "No data found";
}

$conn->close();
?>

<script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div id="chartsContainer"></div>

<script>
// Datos extraídos de la base de datos (por simplicidad, aquí se muestran como ejemplo)
const salesData = <?php echo json_encode($salesData); ?>;

// Crear una función para entrenar el modelo y generar predicciones
async function trainAndPredictForArticle(articleData) {
  const dates = articleData.map(data => new Date(data.fecha));
  const quantities = articleData.map(data => data.cantidad);

  const startDate = new Date(Math.min(...dates));
  const normalizedDates = dates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24))); // Convertir a días enteros

  const maxQuantity = Math.max(...quantities);
  const normalizedQuantities = quantities.map(qty => qty / maxQuantity);

  // Agregar características adicionales
  const months = dates.map(date => date.getMonth() + 1); // Mes del año
  const dayOfWeek = dates.map(date => date.getDay()); // Día de la semana
  const priceVentas = articleData.map(data => data.precio_venta);
  const avgCompra = articleData.map(data => data.precio_promedio_compra);
  const avgVenta = articleData.map(data => data.precio_promedio_venta);

  const maxMonth = Math.max(...months);
  const normalizedMonths = months.map(month => month / maxMonth);

  const maxDayOfWeek = Math.max(...dayOfWeek);
  const normalizedDayOfWeek = dayOfWeek.map(day => day / maxDayOfWeek);

  const maxPriceVenta = Math.max(...priceVentas);
  const normalizedPriceVentas = priceVentas.map(price => price / maxPriceVenta);

  const maxAvgCompra = Math.max(...avgCompra);
  const normalizedAvgCompra = avgCompra.map(price => price / maxAvgCompra);

  // Crear el dataset para TensorFlow.js
  const xs = tf.tensor2d(normalizedDates.map((date, i) => [date, normalizedMonths[i], normalizedDayOfWeek[i], normalizedPriceVentas[i], normalizedAvgCompra[i]]));
  const ys = tf.tensor2d(normalizedQuantities, [normalizedQuantities.length, 1]);

  // Dividir los datos en conjuntos de entrenamiento y prueba
  const splitIndex = Math.floor(xs.shape[0] * 0.8);
  const xsTrain = xs.slice([0, 0], [splitIndex, 5]);
  const ysTrain = ys.slice([0, 0], [splitIndex, 1]);
  const xsTest = xs.slice([splitIndex, 0], [xs.shape[0] - splitIndex, 5]);
  const ysTest = ys.slice([splitIndex, 0], [ys.shape[0] - splitIndex, 1]);

  // Crear el modelo
  const model = tf.sequential();
  model.add(tf.layers.dense({ units: 64, activation: 'relu', inputShape: [5], kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 64, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 32, activation: 'relu', kernelRegularizer: tf.regularizers.l2({ l2: 0.01 }) }));
  model.add(tf.layers.dense({ units: 1 }));

  model.compile({
    optimizer: tf.train.adam(0.0005), // Ajustar la tasa de aprendizaje
    loss: 'meanSquaredError'
  });

  // Callback para detener el entrenamiento si no hay mejora
  const earlyStoppingCallback = tf.callbacks.earlyStopping({
    monitor: 'val_loss',
    patience: 15
  });

  // Entrenar el modelo
  await model.fit(xsTrain, ysTrain, {
    epochs: 300, // Aumentar el número de épocas
    validationData: [xsTest, ysTest],
    callbacks: [earlyStoppingCallback],
    onEpochEnd: (epoch, logs) => {
      console.log(`Epoch ${epoch}: loss = ${logs.loss}`);
    }
  });

  // Obtener la última fecha en el conjunto de datos
  const lastDate = new Date(Math.max(...dates));
  const futureDaysCount = 6; // Número de días futuros a predecir
  const futureDates = Array.from({ length: futureDaysCount }, (_, i) => {
    const futureDate = new Date(lastDate);
    // futureDate.setMonth(futureDate.getMonth() + (i + 1) * 30); // Ejemplo: predicciones para cada mes (30 días)
    futureDate.setDate(futureDate.getDate() + (i + 1) * 30); // para días
    return futureDate;
  });

  const futureDays = futureDates.map(date => Math.floor((date - startDate) / (1000 * 60 * 60 * 24)));
  const futureMonths = futureDates.map(date => (date.getMonth() + 1) / maxMonth);
  const futureDayOfWeek = futureDates.map(date => date.getDay() / maxDayOfWeek);
  const futurePriceVenta = futureDates.map(date => articleData[0].precio_venta / maxPriceVenta);
  const futureAvgCompra = futureDates.map(date => articleData[0].precio_promedio_compra / maxAvgCompra);

  const futureData = futureDays.map((day, i) => [day, futureMonths[i], futureDayOfWeek[i], futurePriceVenta[i], futureAvgCompra[i]]);
  const futureDatesTensor = tf.tensor2d(futureData);

  const predictions = model.predict(futureDatesTensor);

  const predictedQuantities = await predictions.array();
  // const labels = futureDates.map(date => date.toDateString());
  const labels = futureDates.map(date => `${date.toLocaleString('default', { month: 'long' })} ${date.getFullYear()}`);

  // Crear el gráfico para este artículo
  const chartContainer = document.getElementById('chartsContainer');
  const canvas = document.createElement('canvas');
  canvas.id = `chart-${articleData[0].articulo}`;
  chartContainer.appendChild(canvas);
  const ctx = canvas.getContext('2d');

  new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        // label: `Cantidad Predicha (${articleData[0].nombre})`,
        label: `(${articleData[0].nombre})`,
        data: predictedQuantities.map(pred => Math.round(pred[0] * maxQuantity)),
        borderColor: 'rgba(75, 192, 192, 1)',
        borderWidth: 1,
        fill: false
      }]
    },
    options: {
      scales: {
        y: {
          beginAtZero: true
        }
      }
    }
  });

  predictedQuantities.forEach((pred, index) => {
    const predictedQuantity = Math.round(pred[0] * maxQuantity); // Redondear a enteros
    const futureDate = futureDates[index];

    // Calcular la ganancia y determinar la rentabilidad
    const precioPromedioCompra = articleData[0].precio_promedio_compra; // Suponiendo que todos los productos tienen el mismo precio de compra
    const precioPromedioVenta = articleData[0].precio_venta; // Suponiendo que todos los productos tienen el mismo precio de venta
    const ganancia = predictedQuantity * Math.round(articleData[0].precio_promedio_venta);
    const rentable = ganancia > 500 ? 'Rentable' : 'No rentable';

    console.log(`Producto: ${(articleData[0].articulo)}:`);
    console.log(`Prediction for ${futureDate.toDateString()}:`);
    console.log(`Cantidad: ${predictedQuantity}`);
    console.log(`Ganancia: ${ganancia.toFixed(2)}`);
    console.log(`Rentabilidad: ${rentable}`);
    console.log(`Precio Promedio Venta: ${Math.round(articleData[0].precio_promedio_venta)}`);
  });
}

// Llamar a la función para cada artículo en salesData
const articles = salesData.reduce((acc, item) => {
  (acc[item.articulo] = acc[item.articulo] || []).push(item);
  return acc;
}, {});

for (const article in articles) {
  trainAndPredictForArticle(articles[article]);
}
</script>