<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <!-- Espacio para un título si lo requieres -->
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
                                        <?php
                                        $base = Database::getInstance();
                                        $con = $base->getConnection();
                                        $query = "SELECT MONTH(fecha) AS mes, YEAR(fecha) AS anio, accion, SUM(cantidad) as cantidad_total FROM proceso GROUP BY anio, mes, accion";
                                        $result = mysqli_query($con, $query);
                                        $data = array(
                                            'compra' => array_fill(1, 12, 0), // Inicializa un array con 12 elementos con valor 0
                                            'venta' => array_fill(1, 12, 0) // Inicializa un array con 12 elementos con valor 0
                                        );
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            switch ($row['accion']) {
                                                case 1:
                                                    $data['compra'][$row['mes']] = $row['cantidad_total'];
                                                    break;
                                                case 2:
                                                    $data['venta'][$row['mes']] = $row['cantidad_total'];
                                                    break;
                                            }
                                        }
                                        ?>
                                    <div class="container">
                                        <label for="chartType">Selecciona el tipo de gráfico:</label>
                                        <select id="chartType">
                                            <option value="bar">Gráfico de Barras</option>
                                            <option value="line">Gráfico de Líneas</option>
                                            <option value="area">Gráfico de Área</option>
                                            <option value="pie">Gráfico de Torta</option>
                                        </select>
                                        <div id="chart"></div>
                                    </div>

                                <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
                                <script>
                                    var chartTypeSelect = document.getElementById('chartType');
                                    var chart;

                                    function renderChart(chartType) {
                                        if (chart) {
                                            chart.destroy();
                                        }

                                        var options = {
                                            // Configuración del gráfico
                                            chart: {
                                                type: chartType,
                                                height: 400,
                                                toolbar: {
                                                    show: false
                                                }
                                            },
                                            // Datos del gráfico
                                            series: [{
                                                name: 'Compras',
                                                data: <?= json_encode(array_values($data['compra'])) ?>
                                            }, {
                                                name: 'Ventas',
                                                data: <?= json_encode(array_values($data['venta'])) ?>
                                            }],
                                            // Configuración del eje X
                                            xaxis: {
                                                categories: <?= json_encode(array('Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic')) ?>
                                            },
                                            // Configuración del eje Y
                                            yaxis: {
                                                title: {
                                                    text: 'Cantidad',
                                                    style: {
                                                        color: '#333',
                                                        fontSize: '16px'
                                                    }
                                                },
                                                labels: {
                                                    style: {
                                                        colors: '#333',
                                                        fontSize: '14px'
                                                    }
                                                }
                                            },
                                            // Configuración de la leyenda
                                            legend: {
                                                position: 'top',
                                                horizontalAlign: 'center',
                                                offsetY: -20,
                                                labels: {
                                                    colors: '#333',
                                                    fontSize: '14px'
                                                }
                                            },
                                            // Configuración de la cuadrícula
                                            grid: {
                                                borderColor: '#ccc'
                                            }
                                        };

                                        if (chartType === 'pie') {
                                            // Configuración adicional para el gráfico de pie
                                            options.labels = <?= json_encode(array_keys($data['compra'])) ?>;
                                            options.chart.type = 'pie';
                                            options.chart.sparkline = {
                                                enabled: true
                                            };
                                        }

                                        // Crear el gráfico
                                        chart = new ApexCharts(document.querySelector("#chart"), options);
                                        chart.render();
                                    }

                                    // Evento de cambio de selección del tipo de gráfico
                                    chartTypeSelect.addEventListener('change', function () {
                                        renderChart(this.value);
                                    });

                                    // Renderizar el gráfico inicialmente
                                    renderChart(chartTypeSelect.value);
                                </script>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 