<?php
// Obtener parámetro para saber si se está mostrando todo
$mostrarTodo = isset($_GET['mostrar_todo']) ? $_GET['mostrar_todo'] : false;

// Obtener los clientes
if ($mostrarTodo) {
    $operaciones = ClienteData::getAllClientes();
} else {
    $operaciones = ClienteData::reporte1($_GET['desde'] ?? '', $_GET['hasta'] ?? '', 'cliente');
}

if (count($operaciones) > 0) {
?>
<table id="reportestable" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
    <thead>
        <tr>
            <th>Cliente</th>
            <th>Telefono</th>
            <th>Email</th>
            <th>Estado</th>
            <th>Fecha</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($operaciones as $data) { ?>
        <tr>
            <td><?= $data->nombre;?></td>
            <td><?= $data->telefono;?></td>
            <td><?= $data->email;?></td>
            <td>
                <?php if ($data->estado == 1) { ?>
                    <i class="ri-check-line text-success"></i> 
                <?php } else { ?>
                    <i class="ri-close-line text-danger"></i>
                <?php } ?>
            </td>
            <td><?= $data->fecha;?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>
<?php 
} else {
    echo "<div class='alert alert-info'>No se encontraron clientes registrados en el sistema.</div>";
}
?>