<?php
require_once('tcpdf/tcpdf.php');
require_once('core/autoload.php');

class MYPDF extends TCPDF {
    public function Header() {
        // Logo
        $image_file = 'core/app/view/assets/img/logo.png';
        if (file_exists($image_file)) {
            $this->Image($image_file, 15, 10, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }
        
        // Título
        $this->SetFont('helvetica', 'B', 20);
        $this->SetTextColor(33, 33, 33);
        $this->Cell(0, 20, 'COMPROBANTE DE TRANSFERENCIA', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        
        // Línea decorativa
        $this->SetLineWidth(0.5);
        $this->SetDrawColor(0, 150, 136);
        $this->Line(15, 35, 195, 35);
    }

    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->SetTextColor(128, 128, 128);
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Crear nuevo documento PDF
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Configurar documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistema de Ventas');
$pdf->SetTitle('Comprobante de Transferencia');

// Configurar márgenes
$pdf->SetMargins(15, 40, 15);
$pdf->SetHeaderMargin(5);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(TRUE, 15);

// Obtener datos de la transferencia
$transferencia = TransferenciaData::verid($_GET['tid']);

// Obtener los items de la transferencia (solo las salidas)
$sql = "SELECT 
    p.articulo,
    p.almacen,
    p.cantidad,
    (SELECT almacen FROM proceso WHERE transferencia = p.transferencia AND articulo = p.articulo AND accion = 1) as almacen_destino
FROM proceso p
WHERE p.transferencia = ".$_GET['tid']."
AND p.accion = 2
ORDER BY p.articulo";

$query = Executor::doit($sql);
$items = Model::many($query[0], new ProcesoData());

// Información de la transferencia
$html = '
<style>
    .info-box {
        border: 1px solid #e0e0e0;
        padding: 15px;
        margin-bottom: 20px;
        background-color: #f8f9fa;
        border-radius: 5px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .info-box table {
        width: 100%;
    }
    .info-box td {
        padding: 5px 0;
    }
    .table-items {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .table-items th {
        background-color: #009688;
        color: white;
        padding: 12px;
        text-align: center;
        font-weight: bold;
    }
    .table-items td {
        padding: 10px;
        border-bottom: 1px solid #e0e0e0;
    }
    .table-items tr:nth-child(even) {
        background-color: #f8f9fa;
    }
    .total-box {
        margin-top: 30px;
        padding: 15px;
        background-color: #e8f5e9;
        border-radius: 5px;
        text-align: right;
        font-weight: bold;
        color: #2e7d32;
    }
    .signature-box {
        margin-top: 50px;
        text-align: right;
    }
    .signature-line {
        border-top: 1px solid #009688;
        width: 200px;
        margin-left: auto;
        margin-right: 0;
        margin-top: 50px;
    }
</style>

<div class="info-box">
    <table>
        <tr>
            <td width="30%"><strong>Número de Transferencia:</strong></td>
            <td width="70%">TR-'.str_pad($transferencia->codigo, 6, "0", STR_PAD_LEFT).'</td>
        </tr>
        <tr>
            <td><strong>Fecha:</strong></td>
            <td>'.date('d/m/Y H:i:s', strtotime($transferencia->fecha)).'</td>
        </tr>
        <tr>
            <td><strong>Descripción:</strong></td>
            <td>'.$transferencia->descripcion.'</td>
        </tr>
    </table>
</div>

<table class="table-items">
    <thead>
        <tr>
            <th width="40%">Artículo</th>
            <th width="20%">Almacén Origen</th>
            <th width="20%">Almacén Destino</th>
            <th width="20%">Cantidad</th>
        </tr>
    </thead>
    <tbody>';

$total_unidades = 0;
foreach($items as $item) {
    $articulo = ArticuloData::verid($item->articulo);
    $almacen_origen = AlmacenData::verid($item->almacen);
    $almacen_destino = AlmacenData::verid($item->almacen_destino);
    
    $html .= '
        <tr>
            <td>'.$articulo->nombre.'</td>
            <td align="center">'.$almacen_origen->nombre.'</td>
            <td align="center">'.$almacen_destino->nombre.'</td>
            <td align="right">'.$item->cantidad.'</td>
        </tr>';
    $total_unidades += $item->cantidad;
}

$html .= '
    </tbody>
</table>

<div class="total-box">
    Total de Unidades Transferidas: '.$total_unidades.'
</div>

<div class="signature-box">
    <div class="signature-line"></div>
    <div style="margin-top: 5px; color: #009688;">Firma Autorizada</div>
</div>';

// Agregar página
$pdf->AddPage();

// Escribir el contenido HTML
$pdf->writeHTML($html, true, false, true, false, '');

// Cerrar y generar PDF
$pdf->Output('transferencia_'.str_pad($transferencia->codigo, 6, "0", STR_PAD_LEFT).'.pdf', 'I');
?> 