<?php
require_once('tcpdf/tcpdf.php'); // Necesitarás incluir la librería TCPDF

class PDF extends TCPDF {
    public function Header() {
        $this->SetFont('helvetica', 'B', 16);
        $this->Cell(0, 15, 'REPORTE DE COMPRAS', 0, false, 'C', 0, '', 0, false, 'M', 'M');
        $this->Ln(0);
    }
    
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Obtener parámetros
$tipo = $_GET['tipo'] ?? 'general';
$fecha_inicio = $_GET['start'] ?? null;
$fecha_fin = $_GET['end'] ?? null;

try {
    // Crear nueva instancia PDF
    $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // Configuración del documento
    $pdf->SetCreator('Sistema de Compras');
    $pdf->SetAuthor('Sistema de Compras');
    $pdf->SetTitle('Reporte de Compras');
    $pdf->SetSubject('Reporte de Compras');
    $pdf->SetKeywords('compras, reporte, PDF');
    
    // Configuración de página
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    
    // Agregar página
    $pdf->AddPage('L'); // Orientación horizontal para mejor visualización de la tabla
    
    // Título y fechas
    $pdf->SetFont('helvetica', 'B', 12);
    if ($tipo == 'filtrado' && ($fecha_inicio || $fecha_fin)) {
        $titulo_fecha = "Reporte Filtrado";
        if ($fecha_inicio && $fecha_fin) {
            $titulo_fecha .= " del " . date('d/m/Y', strtotime($fecha_inicio)) . " al " . date('d/m/Y', strtotime($fecha_fin));
        } elseif ($fecha_inicio) {
            $titulo_fecha .= " desde " . date('d/m/Y', strtotime($fecha_inicio));
        } elseif ($fecha_fin) {
            $titulo_fecha .= " hasta " . date('d/m/Y', strtotime($fecha_fin));
        }
        $pdf->Cell(0, 10, $titulo_fecha, 0, 1, 'C');
    } else {
        $pdf->Cell(0, 10, "Reporte General de Compras", 0, 1, 'C');
    }
    
    $pdf->Ln(3);
    
    // Obtener datos según el tipo
    if ($tipo == 'filtrado') {
        $compras = CompraData::vercontenido_reporte($fecha_inicio, $fecha_fin);
    } else {
        $compras = CompraData::vercontenido_reporte();
    }
    
    if (empty($compras)) {
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Cell(0, 10, 'No se encontraron datos para mostrar.', 0, 1, 'C');
    } else {
        // Encabezados de tabla
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->SetFillColor(200, 220, 255);
        
        $pdf->Cell(25, 8, 'Fecha', 1, 0, 'C', 1);
        $pdf->Cell(35, 8, 'Recibidor', 1, 0, 'C', 1);
        $pdf->Cell(30, 8, 'Artículos', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'Cantidad', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'P. Unitario', 1, 0, 'C', 1);
        $pdf->Cell(28, 8, 'P. Total Art.', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'Subtotal', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'Descuento', 1, 0, 'C', 1);
        $pdf->Cell(20, 8, 'IGV', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'Total', 1, 1, 'C', 1);
        
        // Datos de tabla
        $pdf->SetFont('helvetica', '', 7);
        $total_general = 0;
        
        foreach ($compras as $compra) {
            $id_compra = $compra->id;
            $detalles = ProcesoData::vercontenidos($id_compra);
            $num_articulos = count($detalles);
            
            if ($num_articulos > 0) {
                $row_height = 6;
                $block_height = $row_height * $num_articulos;
        
                // Verificar si necesitamos nueva página
                if ($pdf->GetY() + $block_height > 190) {
                    $pdf->AddPage('L');
                    // Repetir encabezados
                    $pdf->SetFont('helvetica', 'B', 8);
                    $pdf->SetFillColor(200, 220, 255);
                    $pdf->Cell(25, 8, 'Fecha', 1, 0, 'C', 1);
                    $pdf->Cell(35, 8, 'Recibidor', 1, 0, 'C', 1);
                    $pdf->Cell(30, 8, 'Artículos', 1, 0, 'C', 1);
                    $pdf->Cell(25, 8, 'Cantidad', 1, 0, 'C', 1);
                    $pdf->Cell(25, 8, 'P. Unitario', 1, 0, 'C', 1);
                    $pdf->Cell(28, 8, 'P. Total Art.', 1, 0, 'C', 1);
                    $pdf->Cell(25, 8, 'Subtotal', 1, 0, 'C', 1);
                    $pdf->Cell(25, 8, 'Descuento', 1, 0, 'C', 1);
                    $pdf->Cell(20, 8, 'IGV', 1, 0, 'C', 1);
                    $pdf->Cell(25, 8, 'Total', 1, 1, 'C', 1);
                    $pdf->SetFont('helvetica', '', 7);
                }
        
                $startY = $pdf->GetY();
                $startX = $pdf->GetX();
        
                // Celdas combinadas verticales
                $pdf->Cell(25, $block_height, date('d/m/Y', strtotime($compra->fecha)), 1, 0, 'C');
                $pdf->Cell(35, $block_height, $compra->responsable, 1, 0, 'C');

        
                foreach ($detalles as $index => $detalle) {
                    $cantidad_final = $detalle->cantidad / $detalle->cantidad_unidad;
                    $precio_total_articulo = $detalle->precio * $cantidad_final;
        
                    // Para el resto de las columnas
                    $pdf->SetXY($startX + 60, $startY + ($index * $row_height));
                    $pdf->Cell(30, $row_height, $detalle->articulos, 1, 0, 'L');
                    $pdf->Cell(25, $row_height, number_format($cantidad_final, 2) . ' ' . $detalle->unidades, 1, 0, 'C');
                    $pdf->Cell(25, $row_height, $compra->simbolo . ' ' . number_format($detalle->precio, 2), 1, 0, 'R');
                    $pdf->Cell(28, $row_height, $compra->simbolo . ' ' . number_format($precio_total_articulo, 2), 1, 0, 'R');
        
                    if ($index == 0) {
                        $pdf->Cell(25, $block_height, $compra->simbolo . ' ' . number_format($compra->subtotal, 2), 1, 0, 'R');
                        $pdf->Cell(25, $block_height, $compra->simbolo . ' ' . number_format($compra->descuento, 2), 1, 0, 'R');
                        $pdf->Cell(20, $block_height, $compra->simbolo . ' ' . number_format($compra->igv, 2), 1, 0, 'R');
                        $pdf->Cell(25, $block_height, $compra->simbolo . ' ' . number_format($compra->total, 2), 1, 0, 'R');
                        $total_general += $compra->total;
                    }
        
                    $pdf->Ln();
                }
            } else {
                // Para compras sin detalles
                $pdf->Cell(25, 6, date('d/m/Y', strtotime($compra->fecha)), 1, 0, 'C');
                $pdf->Cell(35, 6, $compra->responsable, 1, 0, 'L');
                $pdf->Cell(30, 6, 'Sin artículos', 1, 0, 'C');
                $pdf->Cell(25, 6, '-', 1, 0, 'C');
                $pdf->Cell(25, 6, '-', 1, 0, 'C');
                $pdf->Cell(28, 6, '-', 1, 0, 'C');
                $pdf->Cell(25, 6, $compra->simbolo . ' ' . number_format($compra->subtotal, 2), 1, 0, 'R');
                $pdf->Cell(25, 6, $compra->simbolo . ' ' . number_format($compra->descuento, 2), 1, 0, 'R');
                $pdf->Cell(20, 6, $compra->simbolo . ' ' . number_format($compra->igv, 2), 1, 0, 'R');
                $pdf->Cell(25, 6, $compra->simbolo . ' ' . number_format($compra->total, 2), 1, 1, 'R');
                $total_general += $compra->total;
            }
        }
        
        // Total general
        $pdf->Ln(3);
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(238, 8, 'TOTAL GENERAL: S/. ' . number_format($total_general, 2), 1, 1, 'R', 1);
    }
    
    // Información adicional
    $pdf->Ln(5);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 6, 'Generado el: ' . date('d/m/Y H:i:s'), 0, 1, 'R');
    
    // Salida del PDF
    $filename = 'reporte_compras_' . date('Y-m-d_H-i-s') . '.pdf';
    $pdf->Output($filename, 'I'); // 'I' para mostrar en el navegador
    
} catch (Exception $e) {
    // En caso de error, mostrar mensaje
    echo "Error al generar el PDF: " . $e->getMessage();
}
?>