<?php
// Este archivo debe ser incluido en tu sistema donde manejas la acción 'filtro_operaciones'

if (isset($_POST['start']) || isset($_POST['end'])) {
    $fecha_inicio = !empty($_POST['start']) ? $_POST['start'] : null;
    $fecha_fin = !empty($_POST['end']) ? $_POST['end'] : null;
    
    // Obtener operaciones (compras y ventas) con filtros
    $operaciones = CompraData::vercontenido_reporte_nuevo($fecha_inicio, $fecha_fin);
    
    if (empty($operaciones)) {
        echo '<tr><td colspan="13" class="text-center text-muted">No se encontraron resultados para el filtro aplicado</td></tr>';
    } else {
        foreach($operaciones as $operacion) {
            $id_operacion = $operacion->id;
            $tipo_operacion = $operacion->tipo_operacion;
            $detalles = ProcesoData::vercontenidos_nuevo($id_operacion, $tipo_operacion);
            $num_articulos = count($detalles);
            ?>
            <tr>
                <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>"><?= htmlspecialchars($operacion->fecha); ?></td>
                <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>">
                    <span class="badge <?= $tipo_operacion === 'COMPRA' ? 'bg-success' : 'bg-danger'; ?>">
                        <i class="fas <?= $tipo_operacion === 'COMPRA' ? 'fa-plus' : 'fa-minus'; ?> me-1"></i>
                        <?= $tipo_operacion; ?>
                    </span>
                </td>
                
                <?php if($num_articulos > 0): ?>
                    <?php $first = true; ?>
                    <?php foreach($detalles as $detalle): ?>
                        <?php if(!$first): ?>
                            <tr>
                        <?php endif; ?>
                        
                        <td><?= htmlspecialchars($detalle->articulos); ?></td>
                        <td>
                            <?php 
                                $cantidad_final = $detalle->cantidad / $detalle->cantidad_unidad;
                                echo number_format($cantidad_final) . " " . htmlspecialchars($detalle->unidades);
                            ?>
                        </td>
                        <td>
                            <?php 
                                // Obtener saldo anterior POR ALMACÉN (antes de esta operación)
                                $saldo_anterior = ProcesoData::obtenerSaldoAnteriorPorAlmacen_nuevo(
                                    $detalle->articulo, 
                                    $detalle->almacen, 
                                    $operacion->fecha,
                                    $tipo_operacion,
                                    $id_operacion
                                );
                                echo number_format($saldo_anterior) . " " . htmlspecialchars($detalle->unidades);
                            ?>
                        </td>
                        <td>
                            <?php 
                                // Stock actual después de la operación
                                $stock_actual = ProcesoData::calcularStockDespuesOperacion(
                                    $saldo_anterior, 
                                    $cantidad_final, 
                                    $tipo_operacion
                                );
                                $color_class = $stock_actual < 0 ? 'text-danger fw-bold' : '';
                                echo '<span class="' . $color_class . '">' . number_format($stock_actual) . " " . htmlspecialchars($detalle->unidades) . '</span>';
                            ?>
                        </td>
                        <td><?= htmlspecialchars($detalle->almacenes); ?></td>
                        
                        <?php if(!$first): ?>
                            </tr>
                        <?php endif; ?>
                        <?php $first = false; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    <td>Sin artículos</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                <?php endif; ?>
            </tr>
            <?php
        }
    }
} else {
    echo '<tr><td colspan="13" class="text-center text-muted">No se enviaron parámetros de filtro</td></tr>';
}
?>