<?php
// Este archivo debe ser incluido en tu sistema donde manejas la acción 'filtro_compras'

if (isset($_POST['start']) || isset($_POST['end'])) {
    $fecha_inicio = !empty($_POST['start']) ? $_POST['start'] : null;
    $fecha_fin = !empty($_POST['end']) ? $_POST['end'] : null;
    
    // Obtener compras con filtros
    $compras = CompraData::vercontenido_reporte($fecha_inicio, $fecha_fin);
    
    if (empty($compras)) {
        echo '<tr><td colspan="10" class="text-center text-muted">No se encontraron resultados para el filtro aplicado</td></tr>';
    } else {
        foreach($compras as $compra) {
            $id_compra = $compra->id;
            $detalles = ProcesoData::vercontenidos($id_compra);
            $num_articulos = count($detalles);
            ?>
            <tr>
                <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>"><?= htmlspecialchars($compra->fecha); ?></td>
                <td rowspan="<?= $num_articulos > 0 ? $num_articulos : 1; ?>"><?= htmlspecialchars($compra->responsable); ?></td>
                
                <?php if($num_articulos > 0): ?>
                    <?php $first = true; ?>
                    <?php foreach($detalles as $detalle): ?>
                        <?php if(!$first): ?>
                            <tr>
                        <?php endif; ?>
                        
                        <td><?= htmlspecialchars($detalle->articulos); ?></td>
                        <td>
                            <?php 
                                $cantidad_final = $detalle->cantidad / $detalle->cantidad_unidad;
                                echo number_format($cantidad_final, 2) . " " . htmlspecialchars($detalle->unidades);
                            ?>
                        </td>
                        <td><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($detalle->precio, 2); ?></td>
                        <td>
                            <?php 
                                $precio_total_articulo = $detalle->precio * $cantidad_final;
                                echo htmlspecialchars($compra->simbolo) . ". " . number_format($precio_total_articulo, 2);
                            ?>
                        </td>
                        
                        <?php if($first): ?>
                            <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->subtotal, 2); ?></td>
                            <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->descuento, 2); ?></td>
                            <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->igv, 2); ?></td>
                            <td rowspan="<?= $num_articulos; ?>"><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->total, 2); ?></td>
                        <?php endif; ?>
                        
                        <?php if(!$first): ?>
                            </tr>
                        <?php endif; ?>
                        <?php $first = false; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    <td>Sin artículos</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->subtotal, 2); ?></td>
                    <td><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->descuento, 2); ?></td>
                    <td><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->igv, 2); ?></td>
                    <td><?= htmlspecialchars($compra->simbolo); ?>. <?= number_format($compra->total, 2); ?></td>
                <?php endif; ?>
            </tr>
            <?php
        }
    }
} else {
    echo '<tr><td colspan="10" class="text-center text-muted">No se enviaron parámetros de filtro</td></tr>';
}
?>